/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util.param;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.util.SuiteListSelectionDialog;
import org.testng.eclipse.util.param.TestNGMethodParameterVisitor;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParameterSolver {
    public static Map<String, String> solveParameters(IJavaElement[] javaElements) {
        HashMap paramNames = Maps.newHashMap();
        if (javaElements == null || javaElements.length == 0) {
            return paramNames;
        }
        try {
            IJavaElement[] iJavaElementArray = javaElements;
            int n = javaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement javaElement = iJavaElementArray[n2];
                Map<String, String> params = ParameterSolver.getParameterNames(javaElement);
                paramNames.putAll(params);
                ++n2;
            }
            if (paramNames.isEmpty()) {
                return paramNames;
            }
            return ParameterSolver.findParameterValues(javaElements[0].getAncestor(2).getCorrespondingResource(), paramNames);
        }
        catch (JavaModelException jmex) {
            TestNGPlugin.log(jmex);
            return paramNames;
        }
    }

    private static Map<String, String> getParameterNames(IJavaElement javaElement) throws JavaModelException {
        switch (javaElement.getElementType()) {
            case 4: {
                return ParameterSolver.solveParameters((IPackageFragment)javaElement);
            }
            case 5: {
                return ParameterSolver.solveParameters((ICompilationUnit)javaElement);
            }
            case 7: {
                return ParameterSolver.solveParameters((IType)javaElement);
            }
            case 9: {
                return ParameterSolver.solveParameters((IMethod)javaElement);
            }
        }
        return Maps.newHashMap();
    }

    private static Map<String, String> solveParameters(IPackageFragment packageFragment) throws JavaModelException {
        return ParameterSolver.parseParameterNames(packageFragment.getCompilationUnits(), new TestNGMethodParameterVisitor());
    }

    private static Map<String, String> solveParameters(ICompilationUnit compilationUnit) throws JavaModelException {
        return ParameterSolver.parseParameterNames(new ICompilationUnit[]{compilationUnit}, new TestNGMethodParameterVisitor());
    }

    private static Map<String, String> solveParameters(IType type) {
        return ParameterSolver.parseParameterNames(new ICompilationUnit[]{type.getCompilationUnit()}, new TestNGMethodParameterVisitor(type));
    }

    private static Map<String, String> solveParameters(IMethod method) throws JavaModelException {
        if (method.getNumberOfParameters() > 0) {
            return ParameterSolver.parseParameterNames(new ICompilationUnit[]{method.getCompilationUnit()}, new TestNGMethodParameterVisitor(method));
        }
        return Maps.newHashMap();
    }

    protected static Map<String, String> parseParameterNames(ICompilationUnit[] units, TestNGMethodParameterVisitor visitor) {
        ICompilationUnit[] iCompilationUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            ASTNode node = ParameterSolver.getParserNode(unit);
            node.accept((ASTVisitor)visitor);
            ++n2;
        }
        return visitor.getParametersMap();
    }

    protected static ASTNode getParserNode(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(unit);
        return parser.createAST(null);
    }

    private static Map<String, String> findParameterValues(IResource projectRes, Map<String, String> parameters) {
        IResource[] suiteFiles = ParameterSolver.searchSuites(new IResource[]{projectRes});
        IFile selectedSuite = null;
        if (suiteFiles.length == 0) {
            return Maps.newHashMap();
        }
        selectedSuite = suiteFiles.length > 1 ? ParameterSolver.showSelectionDialog(suiteFiles) : (IFile)suiteFiles[0];
        if (selectedSuite == null) {
            return Maps.newHashMap();
        }
        return ParameterSolver.extractParameterValues(selectedSuite, parameters);
    }

    private static Map<String, String> extractParameterValues(IFile file, Map<String, String> parameters) {
        try {
            InputStream is = file.getContents();
            ParameterValuesContentHandler pvch = new ParameterValuesContentHandler(parameters);
            SAXParserFactory spf = null;
            try {
                spf = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                try {
                    Class<?> cl = Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                    spf = (SAXParserFactory)cl.newInstance();
                }
                catch (Exception ex2) {
                    TestNGPlugin.log(ex2);
                }
            }
            if (spf == null) {
                return parameters;
            }
            spf.setValidating(true);
            SAXParser saxParser = spf.newSAXParser();
            saxParser.parse(is, (DefaultHandler)pvch);
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException ex) {
            TestNGPlugin.log(ex);
        }
        return parameters;
    }

    protected static IFile showSelectionDialog(IResource[] choices) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell parent = window.getShell();
        SuiteListSelectionDialog dialog = new SuiteListSelectionDialog(parent, choices);
        dialog.setTitle("Select parameter definition file");
        int resultCode = dialog.open();
        if (resultCode != 0) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IFile)) {
            return null;
        }
        return (IFile)result[0];
    }

    protected static IResource[] searchSuites(IResource[] scopeResources) {
        FileSearchQuery query = new FileSearchQuery("<!DOCTYPE suite SYSTEM \"http://testng.org/testng-1.0.dtd\" >", false, false, FileTextSearchScope.newSearchScope((IResource[])scopeResources, (String[])new String[]{"*.xml"}, (boolean)false));
        query.run(null);
        FileSearchResult result = (FileSearchResult)query.getSearchResult();
        Object[] elements = result.getElements();
        IResource[] resources = new IResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            resources[i] = (IResource)elements[i];
            ++i;
        }
        return resources;
    }

    static class ParameterValuesContentHandler
    extends DefaultHandler {
        private Map<String, String> m_params;

        public ParameterValuesContentHandler(Map<String, String> parameters) {
            this.m_params = parameters;
        }

        @Override
        public InputSource resolveEntity(String systemId, String publicId) throws SAXException {
            InputSource result = null;
            if ("http://beust.com/testng/testng-1.0.dtd".equals(publicId) || "http://testng.org/testng-1.0.dtd".equals(publicId)) {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("testng-1.0.dtd");
                if (is == null) {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-1.0.dtd");
                    if (is == null) {
                        System.out.println("WARNING: couldn't find in classpath " + publicId + "\n" + "Fetching it from the Web site.");
                        try {
                            result = super.resolveEntity(systemId, publicId);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        result = new InputSource(is);
                    }
                } else {
                    result = new InputSource(is);
                }
            } else {
                try {
                    result = super.resolveEntity(systemId, publicId);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return result;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name = attributes.getValue("name");
            if ("parameter".equals(qName) && this.m_params.containsKey(name)) {
                this.m_params.put(name, attributes.getValue("value"));
            }
        }
    }
}

