/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util.param;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.testng.collections.Lists;

public class TestNGMethodParameterVisitor
extends ASTVisitor {
    private static final String ANNOTATION_PACKAGE = "org.testng.annotations.";
    private static final String PARAMETER_ANNOTATION = "Parameters";
    private static final String PARAMETER_ANNOTATION_FQN = "org.testng.annotations.Parameters";
    private static final String CONFIGURATION_ANNOTATION = "Configuration";
    private static final String CONFIGURATION_ANNOTATION_FQN = "org.testng.annotations.Configuration";
    private static final String TEST_ANNOTATION = "Test";
    private static final String TEST_ANNOTATION_FQN = "org.testng.annotations.Test";
    private static final String DEFAULT_PARAM_VALUE = "param-val-not-found";
    private Map<MethodDeclaration, List<String>> m_parameters = Maps.newHashMap();
    private IType m_typeFilter;
    private IMethod m_methodFilter;

    public TestNGMethodParameterVisitor() {
    }

    public TestNGMethodParameterVisitor(IMethod methodOnly) {
        this.m_methodFilter = methodOnly;
    }

    public TestNGMethodParameterVisitor(IType typeOnly) {
        this.m_typeFilter = typeOnly;
    }

    public boolean visit(TypeDeclaration node) {
        if (this.m_typeFilter != null) {
            return node.getName().getIdentifier().equals(this.m_typeFilter.getElementName());
        }
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        if (this.m_methodFilter != null) {
            return node.getName().getIdentifier().equals(this.m_methodFilter.getElementName()) && node.parameters().size() == this.m_methodFilter.getNumberOfParameters();
        }
        return true;
    }

    public boolean visit(MarkerAnnotation annotation) {
        return false;
    }

    public boolean visit(NormalAnnotation annotation) {
        if (!this.isKnownAnnotation(annotation.getTypeName().getFullyQualifiedName())) {
            return false;
        }
        List values = annotation.values();
        if (values != null && !values.isEmpty()) {
            int i = 0;
            while (i < values.size()) {
                MemberValuePair pair = (MemberValuePair)values.get(i);
                if ("parameters".equals(pair.getName().toString())) {
                    Expression paramAttr = pair.getValue();
                    if (paramAttr instanceof ArrayInitializer) {
                        this.record((MethodDeclaration)annotation.getParent(), (ArrayInitializer)paramAttr);
                    } else if (paramAttr instanceof StringLiteral) {
                        this.record((MethodDeclaration)annotation.getParent(), (StringLiteral)paramAttr);
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public boolean visit(SingleMemberAnnotation annotation) {
        if (this.isParameterAnnotation(annotation.getTypeName().getFullyQualifiedName())) {
            Expression paramValues = annotation.getValue();
            if (paramValues instanceof ArrayInitializer) {
                this.record((MethodDeclaration)annotation.getParent(), (ArrayInitializer)paramValues);
            } else if (paramValues instanceof StringLiteral) {
                this.record((MethodDeclaration)annotation.getParent(), (StringLiteral)paramValues);
            }
        }
        return false;
    }

    public boolean hasParameters() {
        return !this.m_parameters.isEmpty();
    }

    private void record(MethodDeclaration method, List<String> paramNames) {
        this.m_parameters.put(method, paramNames);
    }

    protected void record(MethodDeclaration method, StringLiteral value) {
        if (!Strings.isNullOrEmpty((String)value.getLiteralValue())) {
            ArrayList<String> paramNames = new ArrayList<String>();
            paramNames.add(value.getLiteralValue());
            this.record(method, paramNames);
        }
    }

    protected void record(MethodDeclaration method, ArrayInitializer values) {
        List literals = values.expressions();
        ArrayList<String> paramNames = new ArrayList<String>(literals.size());
        int i = 0;
        while (i < literals.size()) {
            StringLiteral str = (StringLiteral)literals.get(i);
            paramNames.add(str.getLiteralValue());
            ++i;
        }
        this.record(method, paramNames);
    }

    protected boolean isParameterAnnotation(String annotationType) {
        return PARAMETER_ANNOTATION.equals(annotationType) || PARAMETER_ANNOTATION_FQN.equals(annotationType);
    }

    protected boolean isKnownAnnotation(String annotationType) {
        return CONFIGURATION_ANNOTATION.equals(annotationType) || CONFIGURATION_ANNOTATION_FQN.equals(annotationType) || TEST_ANNOTATION.equals(annotationType) || TEST_ANNOTATION_FQN.equals(annotationType);
    }

    public Map<String, String> getParametersMap() {
        HashMap parameterMap = Maps.newHashMap();
        for (Map.Entry<MethodDeclaration, List<String>> paramEntry : this.m_parameters.entrySet()) {
            List optionals = Lists.newArrayList();
            for (Object p : paramEntry.getKey().parameters()) {
                SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)p;
                for (Object pm : paramDecl.modifiers()) {
                    SingleMemberAnnotation paramAnn;
                    if (!(pm instanceof SingleMemberAnnotation) || !"Optional".equals((paramAnn = (SingleMemberAnnotation)pm).getTypeName().toString())) continue;
                    optionals.add(paramAnn.getValue().toString());
                }
            }
            List<String> paramNames = paramEntry.getValue();
            int i = 0;
            while (i < paramNames.size()) {
                String paramName;
                String val = DEFAULT_PARAM_VALUE;
                if (i < optionals.size() && optionals.get(i) != null) {
                    val = (String)optionals.get(i);
                }
                if (!parameterMap.containsKey(paramName = paramNames.get(i)) || DEFAULT_PARAM_VALUE.equals(parameterMap.get(paramName))) {
                    parameterMap.put(paramName, val);
                }
                ++i;
            }
        }
        return parameterMap;
    }
}

