/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.ui.SpringLabelDecorator;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModel;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelListener;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.ui.model.WebflowUIImages;

public class WebflowModelLabelDecorator
extends SpringLabelDecorator
implements ILightweightLabelDecorator {
    public static final String DECORATOR_ID = "org.springframework.ide.eclipse.webflow.ui.model.webflowModelLabelDecorator";
    private IWebflowModelListener listener = new IWebflowModelListener(){

        public void modelChanged(IWebflowProject project) {
            WebflowModelLabelDecorator.this.internalUpdate();
        }
    };

    public static void update() {
        IBaseLabelProvider provider = PlatformUI.getWorkbench().getDecoratorManager().getBaseLabelProvider(DECORATOR_ID);
        if (provider instanceof BeansModelLabelDecorator) {
            ((WebflowModelLabelDecorator)provider).internalUpdate();
        }
    }

    private void internalUpdate() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IBaseLabelProvider provider = PlatformUI.getWorkbench().getDecoratorManager().getBaseLabelProvider("org.springframework.ide.eclipse.ui.model.modelLabelDecorator");
                if (provider != null) {
                    WebflowModelLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent(provider));
                }
                WebflowModelLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WebflowModelLabelDecorator.this));
            }
        });
    }

    public WebflowModelLabelDecorator() {
        Activator.getModel().registerModelChangeListener(this.listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IFolder) {
            this.decorateFolder((IFolder)element, decoration);
        } else if (element instanceof IFile) {
            this.decorateFile((IFile)element, decoration);
        } else if (element instanceof IWebflowModelElement) {
            this.decorateWebflowModelElement((IModelElement)element, decoration);
        } else if (element instanceof IWebflowProject) {
            this.decorateWebflowModelElement((IModelElement)element, decoration);
        }
    }

    protected void decorateFile(IFile file, IDecoration decoration) {
        if (WebflowModelUtils.isWebflowConfig((IResource)file)) {
            this.addErrorOverlay(decoration, this.getSeverity(file));
            decoration.addOverlay(WebflowUIImages.DESC_OVR_WEBFLOW);
        }
    }

    protected void decorateFolder(IFolder folder, IDecoration decoration) {
        IWebflowModel model = Activator.getModel();
        if (model.hasProject(folder.getProject())) {
            IWebflowProject project = model.getProject(folder.getProject());
            String path = String.valueOf(folder.getProjectRelativePath().toString()) + '/';
            for (IWebflowConfig config : project.getConfigs()) {
                if (!config.getResource().getProjectRelativePath().toString().startsWith(path)) continue;
                decoration.addOverlay(WebflowUIImages.DESC_OVR_WEBFLOW);
                break;
            }
        }
    }

    private void decorateWebflowModelElement(IModelElement element, IDecoration decoration) {
        this.addErrorOverlay(decoration, this.getSeverity(element));
    }

    public void dispose() {
        Activator.getModel().removeModelChangeListener(this.listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    protected int getSeverity(Object element) {
        if (element instanceof IWebflowProject) {
            int severity = 0;
            for (IWebflowConfig config : ((IWebflowProject)element).getConfigs()) {
                severity = MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)config.getResource(), (int)-1, (int)-1);
                if (severity == 2) break;
            }
            return severity;
        }
        if (element instanceof IWebflowConfig) {
            return MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)((IWebflowConfig)element).getResource(), (int)-1, (int)-1);
        }
        if (element instanceof IResource) {
            return MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)((IResource)element), (int)-1, (int)-1);
        }
        return 0;
    }
}

