/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinitionFactory;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.ui.Activator;
import org.springframework.ide.eclipse.webflow.ui.model.WebflowModelLabelDecorator;
import org.springframework.ide.eclipse.webflow.ui.properties.WebflowConfigTab;

public class WebflowPropertyPage
extends PropertyPage {
    public static final String ID = "org.springframework.ide.eclipse.webflow.ui.properties.projectPropertyPage";
    public static final String SELECTED_RESOURCE = "org.springframework.ide.eclipse.webflow.ui.properties.projectPropertyPage.selectedResource";
    private static final String TITLE = "ConfigurationPropertyPage.title";
    private static final String CONFIG_FILES_LABEL = "ConfigurationPropertyPage.tabConfigFiles.label";
    private WebflowConfigTab configFilesBlock;
    private Map<String, Object> pageData;
    private IModelElement selectedModelElement;

    public WebflowPropertyPage() {
        this(null);
    }

    public WebflowPropertyPage(IProject project) {
        this.setElement((IAdaptable)project);
        this.setTitle(Activator.getResourceString(TITLE));
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        IWebflowProject project = this.getSpringProject();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(1808));
        this.configFilesBlock = new WebflowConfigTab(project, this.getElement(), this.selectedModelElement);
        TabItem item = new TabItem(folder, 0);
        item.setText(Activator.getResourceString(CONFIG_FILES_LABEL));
        item.setControl(this.configFilesBlock.createControl((Composite)folder));
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    public boolean performOk() {
        IWebflowProject project = this.getSpringProject();
        if (this.configFilesBlock.hasUserMadeChanges()) {
            Set<IWebflowConfig> files = this.configFilesBlock.getConfigFiles();
            Map<IWebflowConfig, Set<IModelElement>> filesToConfig = this.configFilesBlock.getConfigFilesToBeansConfigs();
            Map<IWebflowConfig, String> names = this.configFilesBlock.getConfigFilesToNames();
            ArrayList<IWebflowConfig> webflowConfigs = new ArrayList<IWebflowConfig>();
            for (IWebflowConfig file : files) {
                WebflowConfig webflowConfig = new WebflowConfig(project);
                webflowConfig.setBeansConfigs(filesToConfig.get(file));
                webflowConfig.setResource(file.getResource());
                if (names.get(file) != null) {
                    webflowConfig.setName(names.get(file));
                }
                webflowConfigs.add((IWebflowConfig)webflowConfig);
            }
            List currentConfigs = project.getConfigs();
            for (IWebflowConfig currentConfig : currentConfigs) {
                if (this.getConfig(currentConfig.getResource(), webflowConfigs) != null) continue;
                MarkerUtils.deleteMarkers((IResource)currentConfig.getResource(), (String)ValidatorDefinitionFactory.getValidatorDefinition((String)"org.springframework.ide.eclipse.webflow.core.validator").getMarkerId());
            }
            project.setConfigs(webflowConfigs);
            WebflowModelLabelDecorator.update();
        }
        return super.performOk();
    }

    public IWebflowConfig getConfig(IFile file, List<IWebflowConfig> configs) {
        if (configs != null) {
            for (IWebflowConfig config : configs) {
                if (!config.getResource().equals((Object)file)) continue;
                return config;
            }
        }
        return null;
    }

    protected IWebflowProject getSpringProject() {
        return org.springframework.ide.eclipse.webflow.core.Activator.getModel().getProject((IProject)this.getElement());
    }

    public void dispose() {
        super.dispose();
    }

    public void applyData(Object data) {
        super.applyData(data);
        if (data instanceof Map) {
            this.pageData = (Map)data;
            if (this.pageData.containsKey(SELECTED_RESOURCE) && this.pageData.get(SELECTED_RESOURCE) instanceof IModelElement) {
                this.selectedModelElement = (IModelElement)this.pageData.get(SELECTED_RESOURCE);
            }
        }
    }
}

