/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.filters;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jboss.tools.arquillian.core.internal.archives.IEntry;
import org.jboss.tools.arquillian.core.internal.util.ArquillianSearchEngine;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;

public class ArquillianFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IEntry) {
            return true;
        }
        if (element instanceof IProject) {
            try {
                if (((IProject)element).hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = JavaCore.create((IProject)((IProject)element));
                    return this.hasDeployments((IJavaElement)javaProject);
                }
            }
            catch (CoreException coreException) {}
        } else if (element instanceof IPackageFragment) {
            try {
                return ((IPackageFragment)element).hasSubpackages() || this.hasDeployments((IJavaElement)((IPackageFragment)element));
            }
            catch (JavaModelException e) {
                ArquillianUIActivator.log(e);
            }
        } else if (element instanceof IJavaElement) {
            return this.hasDeployments((IJavaElement)element);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasDeployments(IJavaElement element) {
        try {
            int n;
            int n2;
            IJavaElement[] iJavaElementArray;
            if (element instanceof IJavaProject) {
                return ((IJavaProject)element).getProject().hasNature("org.jboss.tools.arquillian.core.arquillianNature");
            }
            if (element instanceof IPackageFragmentRoot) {
                IJavaElement[] children;
                iJavaElementArray = children = ((IPackageFragmentRoot)element).getChildren();
                n2 = children.length;
                n = 0;
                while (n < n2) {
                    IJavaElement child = iJavaElementArray[n];
                    if (this.hasDeployments(child)) {
                        return true;
                    }
                    ++n;
                }
            }
            if (element instanceof IPackageFragment) {
                ICompilationUnit[] units = ((IPackageFragment)element).getCompilationUnits();
                iJavaElementArray = units;
                n2 = units.length;
                n = 0;
                while (n < n2) {
                    IJavaElement unit = iJavaElementArray[n];
                    if (this.hasDeployments(unit)) {
                        return true;
                    }
                    ++n;
                }
            }
            if (!(element instanceof ICompilationUnit)) return false;
            return ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)((ICompilationUnit)element), (boolean)true, (boolean)false, (boolean)false);
        }
        catch (CoreException e) {
            ArquillianUIActivator.log(e);
        }
        return false;
    }
}

