/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.preferences;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.forge.arquillian.container.Container;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.container.ContainerParser;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.utils.ArquillianUIUtil;

public class ArquillianPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.jboss.tools.arquillian.ui.preferences.arquillianPreferencePage";
    private Combo combo;
    private CheckboxTableViewer profilesViewer;
    private List<Container> containers;
    private Text argumentsText;
    private Button enableButton;
    private Button addToJUnitTestNGButton;
    private Button addToExistingButton;
    private Button allowOSCommandButton;
    private Button allowSPCommandButton;
    private static final String[] defaultVersions = new String[]{"1.1.2.Final"};

    public void init(IWorkbench workbench) {
        this.containers = ContainerParser.getContainers();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        GridData gd = new GridData(4, 4, true, false);
        label.setLayoutData((Object)gd);
        label.setText("Arquillian version:");
        this.combo = new Combo(composite, 8);
        gd = new GridData(4, 4, true, false);
        this.combo.setLayoutData((Object)gd);
        this.combo.setItems(ArquillianUtility.getVersions((String[])defaultVersions));
        String value = ArquillianUtility.getPreference((String)"arquillianVersion", (String)"1.1.2.Final");
        this.combo.setText(value);
        IPreferenceStore prefs = ArquillianCoreActivator.getDefault().getPreferenceStore();
        Font font = parent.getFont();
        Group argumentsGroup = new Group(composite, 0);
        argumentsGroup.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        argumentsGroup.setLayoutData((Object)gd);
        argumentsGroup.setFont(font);
        argumentsGroup.setText("Default VM Arguments");
        Label argumentsLabel = new Label((Composite)argumentsGroup, 0);
        gd = new GridData(4, 4, true, false);
        argumentsLabel.setLayoutData((Object)gd);
        argumentsLabel.setText("Select VM arguments you want to include in a new Arquillian launch configuration.");
        new Label((Composite)argumentsGroup, 0);
        this.enableButton = new Button((Composite)argumentsGroup, 32);
        this.enableButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.enableButton.setText("Enable default VM arguments");
        boolean enable = prefs.getBoolean("enableDefaultVMArguments");
        this.enableButton.setSelection(enable);
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArquillianPreferencePage.this.enableWidgets();
            }
        });
        this.argumentsText = new Text((Composite)argumentsGroup, 2626);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = 50;
        this.argumentsText.setLayoutData((Object)gd);
        this.argumentsText.setText(prefs.getString("defaultVMArguments"));
        this.addToJUnitTestNGButton = new Button((Composite)argumentsGroup, 32);
        this.addToJUnitTestNGButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addToJUnitTestNGButton.setText("Add the default VM arguments to the JUnit/TestNG launch configurations");
        this.addToJUnitTestNGButton.setSelection(prefs.getBoolean("addDefaultVMArgumentstoJUnitTestNG"));
        this.addToExistingButton = new Button((Composite)argumentsGroup, 32);
        this.addToExistingButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addToExistingButton.setText("Add the default VM arguments to the existing launch configurations");
        Group securityGroup = new Group(composite, 0);
        securityGroup.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(4, 4, true, false);
        securityGroup.setLayoutData((Object)gd);
        securityGroup.setText("Security");
        this.allowOSCommandButton = new Button((Composite)securityGroup, 32);
        this.allowOSCommandButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.allowOSCommandButton.setText("Allow running an OS command when analyzing a deployment method");
        this.allowOSCommandButton.setSelection(prefs.getBoolean("allowOSCommand"));
        this.allowSPCommandButton = new Button((Composite)securityGroup, 32);
        this.allowSPCommandButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.allowSPCommandButton.setText("Allow setting a system property when analyzing a deployment method");
        this.allowSPCommandButton.setSelection(prefs.getBoolean("allowSPCommand"));
        Group profilesGroup = new Group(composite, 0);
        profilesGroup.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        profilesGroup.setLayoutData((Object)gd);
        profilesGroup.setText("Profiles");
        Label profilesLabel = new Label((Composite)profilesGroup, 0);
        gd = new GridData(4, 4, true, false);
        profilesLabel.setLayoutData((Object)gd);
        profilesLabel.setText("Select profiles you want to include automatically when adding the Arquillian support.");
        new Label((Composite)profilesGroup, 0);
        this.profilesViewer = ArquillianUIUtil.createProfilesViewer((Composite)profilesGroup, this.containers, 200);
        ArquillianUIUtil.initializeViewer(this.profilesViewer, this.containers);
        this.enableWidgets();
        return composite;
    }

    private void enableWidgets() {
        boolean enabled = this.enableButton.getSelection();
        this.argumentsText.setEditable(enabled);
        this.addToJUnitTestNGButton.setEnabled(enabled);
        this.addToExistingButton.setEnabled(enabled);
    }

    protected void performDefaults() {
        IPreferenceStore prefs = ArquillianCoreActivator.getDefault().getPreferenceStore();
        prefs.setValue("enableDefaultVMArguments", false);
        this.enableButton.setSelection(false);
        prefs.setValue("defaultVMArguments", "-Darquillian.debug=true");
        this.argumentsText.setText("-Darquillian.debug=true");
        prefs.setValue("addDefaultVMArgumentstoJUnitTestNG", false);
        this.addToJUnitTestNGButton.setSelection(false);
        prefs.setValue("allowOSCommand", true);
        this.allowOSCommandButton.setSelection(true);
        prefs.setValue("allowSPCommand", true);
        this.allowSPCommandButton.setSelection(true);
        prefs.setValue("arquillianVersion", "1.1.2.Final");
        this.combo.setText("1.1.2.Final");
        prefs.setValue("selectedArquillianProfiles", "JBOSS_AS_REMOTE_7.X");
        prefs.setValue("activatedArquillianProfiles", "JBOSS_AS_REMOTE_7.X");
        ArquillianUIUtil.initializeViewer(this.profilesViewer, this.containers);
        this.profilesViewer.refresh();
        this.enableWidgets();
        this.addArgumentsInternal(prefs);
        super.performDefaults();
    }

    public void addArgumentsInternal(IPreferenceStore prefs) {
        try {
            this.addArguments(prefs);
        }
        catch (CoreException e) {
            ArquillianUIActivator.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
        }
    }

    public boolean performOk() {
        IPreferenceStore prefs = ArquillianCoreActivator.getDefault().getPreferenceStore();
        prefs.setValue("arquillianVersion", this.combo.getText());
        prefs.setValue("enableDefaultVMArguments", this.enableButton.getSelection());
        prefs.setValue("defaultVMArguments", this.argumentsText.getText());
        prefs.setValue("addDefaultVMArgumentstoJUnitTestNG", this.addToJUnitTestNGButton.getSelection());
        prefs.setValue("allowOSCommand", this.allowOSCommandButton.getSelection());
        prefs.setValue("allowSPCommand", this.allowSPCommandButton.getSelection());
        StringBuilder aBuilder = new StringBuilder();
        StringBuilder sBuilder = new StringBuilder();
        for (Container container : this.containers) {
            if (container.isActivate()) {
                if (aBuilder.length() > 0) {
                    aBuilder.append(",");
                }
                aBuilder.append(container.getId());
            }
            if (!this.profilesViewer.getChecked((Object)container)) continue;
            if (sBuilder.length() > 0) {
                sBuilder.append(",");
            }
            sBuilder.append(container.getId());
        }
        prefs.setValue("selectedArquillianProfiles", sBuilder.toString());
        prefs.setValue("activatedArquillianProfiles", aBuilder.toString());
        this.addArgumentsInternal(prefs);
        return super.performOk();
    }

    private void addArguments(IPreferenceStore prefs) throws CoreException {
        String arguments = prefs.getString("defaultVMArguments");
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        arguments = arguments.trim();
        if (this.addToExistingButton.getSelection()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            this.addArguments(arguments, manager, "org.jboss.tools.arquillian.core.launchconfig");
            if (this.addToJUnitTestNGButton.getSelection()) {
                this.addArguments(arguments, manager, "org.eclipse.jdt.junit.launchconfig");
                this.addArguments(arguments, manager, "org.testng.eclipse.launchconfig");
            }
        }
    }

    public void addArguments(String arguments, ILaunchManager manager, String typeId) throws CoreException {
        ILaunchConfiguration[] configurations;
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(typeId);
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations = manager.getLaunchConfigurations(type);
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            ArquillianUtility.addArguments((ILaunchConfiguration)configuration, (String)arguments, (boolean)true);
            ++n2;
        }
    }
}

