/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.refactoring;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddDependencies
implements PomEdits.Operation {
    private List<Dependency> dependencies;
    private MavenProject mavenProject;

    public AddDependencies(List<Dependency> dependencies, MavenProject mavenProject) {
        this.dependencies = dependencies;
        this.mavenProject = mavenProject;
    }

    public void process(Document document) {
        if (this.dependencies == null || this.dependencies.size() <= 0) {
            return;
        }
        Element root = document.getDocumentElement();
        Element dependenciesEl = PomEdits.getChild((Element)root, (String[])new String[]{"dependencies"});
        for (Dependency dependency : this.dependencies) {
            String version = ArquillianUtility.getDependencyVersion((MavenProject)this.mavenProject, (String)dependency.getGroupId(), (String)dependency.getArtifactId());
            if (version != null) continue;
            PomHelper.addOrUpdateDependency((Element)dependenciesEl, (String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion(), (String)dependency.getType(), (String)dependency.getScope(), (String)dependency.getClassifier());
        }
    }
}

