/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.archives.Entry;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.utils.ArquillianUIUtil;

public class ArquillianView
extends CommonNavigator {
    public static final String ID = "org.jboss.tools.arquillian.ui.views.arquillianView";
    private static final String JAVA = ".java";
    private static final String CLASS = ".class";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes/";
    private static final String META_INF = "META-INF/";
    private static final String WEB_INF = "WEB-INF/";
    private IResourceChangeListener resourceChangeListener;
    private ISelectionListener selectionListener;

    public void dispose() {
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
            this.resourceChangeListener = null;
        }
        if (this.selectionListener != null) {
            this.getSite().getPage().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        super.dispose();
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer commonViewer = super.createCommonViewer(aParent);
        this.selectionListener = new ISelectionListener(){
            private IProject oldSelected;

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                IProject selected = ArquillianUIUtil.getSelectedProject(selection);
                if (part == ArquillianView.this) {
                    this.oldSelected = selected;
                    return;
                }
                if (selected == null) {
                    this.oldSelected = null;
                    return;
                }
                if (selected.equals((Object)this.oldSelected)) {
                    return;
                }
                if (ArquillianView.this.getCommonViewer() != null && ArquillianView.this.getCommonViewer().getControl() != null && !ArquillianView.this.getCommonViewer().getControl().isDisposed()) {
                    ArquillianView.this.getCommonViewer().refresh();
                    this.oldSelected = selected;
                }
            }
        };
        this.getSite().getPage().addSelectionListener(this.selectionListener);
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                final HashSet<IProject> toRefresh = new HashSet<IProject>();
                final HashSet<IProject> toRemove = new HashSet<IProject>();
                final HashSet<IProject> toAdd = new HashSet<IProject>();
                if (event.getType() == 4 || event.getType() == 2) {
                    IResource project = event.getResource();
                    if (project != null && project instanceof IProject) {
                        toRemove.add((IProject)project);
                    }
                } else if (event.getType() == 1) {
                    this.handlePostChange(event, toAdd);
                } else {
                    this.handlePostBuild(event, toRefresh);
                }
                if (toRefresh.size() <= 0 && toRemove.size() <= 0 && toAdd.size() <= 0) {
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ArquillianView.this.getCommonViewer() != null && ArquillianView.this.getCommonViewer().getControl() != null && !ArquillianView.this.getCommonViewer().getControl().isDisposed()) {
                            for (IProject project : toRefresh) {
                                ArquillianView.this.getCommonViewer().refresh((Object)project);
                            }
                            for (IProject project : toRemove) {
                                ArquillianView.this.getCommonViewer().remove((Object)project);
                            }
                            if (toAdd.size() > 0) {
                                ArquillianView.this.getCommonViewer().refresh();
                            }
                        }
                    }
                });
            }

            private void handlePostChange(IResourceChangeEvent event, final Set<IProject> projects) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    try {
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                if (delta == null) {
                                    return false;
                                }
                                IResource resource = delta.getResource();
                                if (resource instanceof IWorkspaceRoot) {
                                    return true;
                                }
                                if (resource instanceof IProject && delta.getKind() == 1 && ((IProject)resource).isOpen()) {
                                    projects.add(resource.getProject());
                                }
                                return false;
                            }
                        });
                    }
                    catch (CoreException e) {
                        ArquillianCoreActivator.log((Throwable)e);
                    }
                }
            }

            public void handlePostBuild(IResourceChangeEvent event, final Set<IProject> projects) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    try {
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                if (delta == null) {
                                    return false;
                                }
                                IResource resource = delta.getResource();
                                if (resource instanceof IWorkspaceRoot) {
                                    return true;
                                }
                                if (resource instanceof IProject && ((IProject)resource).isOpen()) {
                                    projects.add((IProject)resource);
                                }
                                return false;
                            }
                        });
                    }
                    catch (CoreException e) {
                        ArquillianCoreActivator.log((Throwable)e);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 23);
        return commonViewer;
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        if (!this.open(anEvent)) {
            super.handleDoubleClick(anEvent);
        }
    }

    private void openFile(IResource resource) throws PartInitException {
        IFile file = (IFile)resource;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean open(DoubleClickEvent event) {
        if (event == null) return false;
        if (!(event.getSelection() instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection structured = (StructuredSelection)event.getSelection();
        Object object = structured.getFirstElement();
        if (!(object instanceof Entry)) return false;
        Entry element = (Entry)object;
        if ("EmptyAsset".equals(element.getType())) return false;
        if ("Archive".equals(element.getType())) return false;
        if ("Directory".equals(element.getType())) return false;
        if (element.getPath() == null) return false;
        if (element.getPath().isEmpty()) {
            return false;
        }
        IJavaProject project = element.getJavaProject();
        if (element.getFullyQualifiedName() != null) {
            try {
                IType type = project.findType(element.getFullyQualifiedName());
                IResource resource = type.getUnderlyingResource();
                if (resource != null && resource.exists()) {
                    this.openFile(resource);
                    return true;
                }
            }
            catch (PartInitException e) {
                ArquillianUIActivator.log(e);
            }
            catch (JavaModelException e) {
                ArquillianUIActivator.log(e);
            }
        }
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = project.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    String name;
                    IPath entryPath = entry.getPath();
                    if (this.openFile(entryPath, name = element.getPath())) {
                        return true;
                    }
                    if (name.startsWith("/WEB-INF")) {
                        if (this.openFile(entryPath, name.substring(8))) {
                            return true;
                        }
                        if (name.startsWith("/META-INF") && this.openFile(entryPath, name.substring(9))) {
                            return true;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            ArquillianUIActivator.log(e);
            return false;
        }
        catch (PartInitException e) {
            ArquillianUIActivator.log(e);
        }
        return false;
    }

    private boolean openFile(IPath root, String name) throws PartInitException {
        IPath path = root.append(name);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource instanceof IFile && resource.exists()) {
            this.openFile(resource);
            return true;
        }
        return false;
    }
}

