/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.model;

import com.atlassian.connector.eclipse.internal.jira.core.model.Attachment;
import com.atlassian.connector.eclipse.internal.jira.core.model.Comment;
import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.CustomField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueLink;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.model.Subtask;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.jira.rest.client.domain.Issue;
import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class JiraIssue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String key;
    private String parentId;
    private String parentKey;
    private String summary;
    private String environment;
    private String description;
    private Project project;
    private IssueType type;
    private Priority priority;
    private JiraStatus status;
    private Resolution resolution;
    private String assignee;
    private String reporter;
    private String assigneeName;
    private String reporterName;
    private Date created;
    private Date updated;
    private Version[] reportedVersions = null;
    private Version[] fixVersions = null;
    private Component[] components = null;
    private Date due;
    private boolean hasDueDate;
    private int votes;
    private Comment[] comments = new Comment[0];
    private Long initialEstimate;
    private Long estimate;
    private long actual;
    private boolean isWatched;
    private boolean hasVote;
    private String url;
    private Attachment[] attachments = new Attachment[0];
    private CustomField[] customFields = new CustomField[0];
    private IssueField[] editableFields = new IssueField[0];
    private Subtask[] subtasks = new Subtask[0];
    private IssueLink[] issueLinks = new IssueLink[0];
    private JiraWorkLog[] worklogs = new JiraWorkLog[0];
    private SecurityLevel securityLevel;
    private boolean markupDetected;
    private URI self;
    private Long rank = null;
    private String[] labels = new String[0];
    private Issue rawIssue;

    public String getId() {
        return this.id;
    }

    public URI getSelf() {
        return this.self;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(String parentKey) {
        this.parentKey = parentKey;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String asignee) {
        this.assignee = asignee;
    }

    public Component[] getComponents() {
        return this.components;
    }

    public void setComponents(Component[] components) {
        this.components = components;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDue() {
        return this.due;
    }

    public void setDue(Date due) {
        this.due = due;
        this.hasDueDate = true;
    }

    public boolean hasDueDate() {
        return this.hasDueDate;
    }

    public Version[] getFixVersions() {
        return this.fixVersions;
    }

    public void setFixVersions(Version[] fixVersions) {
        this.fixVersions = fixVersions;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public JiraStatus getStatus() {
        return this.status;
    }

    public void setStatus(JiraStatus status) {
        this.status = status;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public IssueType getType() {
        return this.type;
    }

    public void setType(IssueType type) {
        this.type = type;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public Version[] getReportedVersions() {
        return this.reportedVersions;
    }

    public void setReportedVersions(Version[] reportedVersions) {
        this.reportedVersions = reportedVersions;
    }

    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int votes) {
        this.votes = votes;
    }

    public Comment[] getComments() {
        return this.comments;
    }

    public void setComments(Comment[] comments) {
        this.comments = comments;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public long getActual() {
        return this.actual;
    }

    public void setActual(long actual) {
        this.actual = actual;
    }

    public Long getInitialEstimate() {
        return this.initialEstimate;
    }

    public void setInitialEstimate(long initialEstimate) {
        this.initialEstimate = initialEstimate;
    }

    public Long getEstimate() {
        return this.estimate;
    }

    public void setEstimate(long estimate) {
        this.estimate = estimate;
    }

    public void setWatched(boolean isWatched) {
        this.isWatched = isWatched;
    }

    public boolean isWatched() {
        return this.isWatched;
    }

    public boolean canUserVote(String user) {
        return (this.getResolution() == null || this.getResolution().getId() == null || "".equals(this.getResolution().getId())) && !user.equals(this.getReporter());
    }

    public void setHasVote(boolean hasVote) {
        this.hasVote = hasVote;
    }

    public boolean getHasVote() {
        return this.hasVote;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return String.valueOf(this.key) + " " + this.summary;
    }

    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Attachment[] attachments) {
        this.attachments = attachments;
    }

    public Attachment getAttachmentById(String id) {
        Attachment[] attachmentArray = this.attachments;
        int n = this.attachments.length;
        int n2 = 0;
        while (n2 < n) {
            Attachment attachment = attachmentArray[n2];
            if (attachment.getId().equals(id)) {
                return attachment;
            }
            ++n2;
        }
        return null;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public CustomField getCustomFieldById(String fieldId) {
        CustomField[] customFieldArray = this.getCustomFields();
        int n = customFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomField field = customFieldArray[n2];
            if (fieldId.equals(field.getId())) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    public Subtask[] getSubtasks() {
        return this.subtasks;
    }

    public void setSubtasks(Subtask[] subtasks) {
        this.subtasks = subtasks;
    }

    public IssueLink[] getIssueLinks() {
        return this.issueLinks;
    }

    public void setIssueLinks(IssueLink[] issueLinks) {
        this.issueLinks = issueLinks;
    }

    public String[] getFieldValues(String field) {
        if ("summary".equals(field)) {
            return new String[]{this.getSummary()};
        }
        if ("description".equals(field)) {
            return new String[]{this.getDescription()};
        }
        if ("resolution".equals(field)) {
            if (this.resolution != null) {
                return new String[]{this.resolution.getId()};
            }
        } else {
            if ("assignee".equals(field)) {
                return new String[]{this.assignee};
            }
            if ("reporter".equals(field)) {
                return new String[]{this.reporter};
            }
            if ("issuetype".equals(field)) {
                if (this.type != null) {
                    return new String[]{this.type.getId()};
                }
            } else if ("priority".equals(field)) {
                if (this.priority != null) {
                    return new String[]{this.getPriority().getId()};
                }
            } else if ("components".equals(field)) {
                if (this.components != null) {
                    String[] res = new String[this.components.length];
                    int i = 0;
                    while (i < this.components.length) {
                        res[i] = this.components[i].getId();
                        ++i;
                    }
                    return res;
                }
            } else if ("versions".equals(field)) {
                if (this.reportedVersions != null) {
                    String[] res = new String[this.reportedVersions.length];
                    int i = 0;
                    while (i < this.reportedVersions.length) {
                        res[i] = this.reportedVersions[i].getId();
                        ++i;
                    }
                    return res;
                }
            } else if ("fixVersions".equals(field)) {
                if (this.fixVersions != null) {
                    String[] res = new String[this.fixVersions.length];
                    int i = 0;
                    while (i < this.fixVersions.length) {
                        res[i] = this.fixVersions[i].getId();
                        ++i;
                    }
                    return res;
                }
            } else if ("environment".equals(field)) {
                if (this.environment != null) {
                    return new String[]{this.environment};
                }
            } else if ("duedate".equals(field)) {
                if (this.due != null) {
                    return new String[]{new SimpleDateFormat("dd/MMM/yy").format(this.due)};
                }
            } else {
                if ("timetracking".equals(field)) {
                    return new String[]{String.valueOf(Long.toString(this.getEstimate() / 60L)) + "m"};
                }
                if ("labels".equals(field)) {
                    return this.getLabels();
                }
                if ("security".equals(field)) {
                    return new String[]{this.getSecurityLevel().getId()};
                }
            }
        }
        if (field.startsWith("customfield_")) {
            CustomField[] customFieldArray = this.customFields;
            int n = this.customFields.length;
            int n2 = 0;
            while (n2 < n) {
                CustomField customField = customFieldArray[n2];
                if (customField.getId().equals(field)) {
                    List<String> values = customField.getValues();
                    values.remove("-1");
                    return values.toArray(new String[values.size()]);
                }
                ++n2;
            }
        }
        return null;
    }

    public SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(SecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
    }

    public boolean isMarkupDetected() {
        return this.markupDetected;
    }

    public void setMarkupDetected(boolean markupDetected) {
        this.markupDetected = markupDetected;
    }

    public String getReporterName() {
        return this.reporterName;
    }

    public void setReporterName(String reporterName) {
        this.reporterName = reporterName;
    }

    public String getAssigneeDisplayName() {
        return this.assigneeName;
    }

    public void setAssigneeName(String assigneeName) {
        this.assigneeName = assigneeName;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public JiraWorkLog[] getWorklogs() {
        return this.worklogs;
    }

    public void setWorklogs(JiraWorkLog[] worklogs) {
        this.worklogs = worklogs;
    }

    public void setRank(Long rank) {
        this.rank = rank;
    }

    public Long getRank() {
        return this.rank;
    }

    public IssueField[] getEditableFields() {
        return this.editableFields;
    }

    public void setEditableFields(IssueField[] editableFields) {
        this.editableFields = editableFields;
    }

    public void setLabels(String[] strings) {
        this.labels = strings;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setRawIssue(Issue rawIssue) {
        this.rawIssue = rawIssue;
    }

    public Issue getRawIssue() {
        return this.rawIssue;
    }
}

