/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.fieldassist.FieldAssistColors;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.ui.SpringUIImages;
import org.springframework.ide.eclipse.ui.internal.navigator.SpringNavigatorContentProvider;
import org.springframework.ide.eclipse.ui.internal.navigator.SpringNavigatorLabelProvider;
import org.springframework.ide.eclipse.ui.workingsets.IElementSpecificLabelProvider;
import org.springframework.ide.eclipse.ui.workingsets.WorkingSetUtils;

public class SpringWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text text;
    private CheckboxTreeViewer tree;
    private IWorkingSet workingSet;
    private boolean firstCheck = false;
    private ITreeContentProvider contentProvider = new SpringExplorerAdaptingContentProvider();

    public SpringWorkingSetPage() {
        super("springWorkingSet", "Spring Working Set", SpringUIImages.DESC_WIZ_WORKINGSET);
        this.setDescription("Enter a working set name and select the working set elements.");
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText("Working set name:");
        GridData data = new GridData(772);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setFont(font);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SpringWorkingSetPage.this.validateInput();
            }
        });
        this.text.setFocus();
        this.text.setBackground(FieldAssistColors.getRequiredFieldBackgroundColor((Control)this.text));
        label = new Label(composite, 64);
        label.setText("Working set &contents:");
        data = new GridData(772);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.tree = new CheckboxTreeViewer(composite);
        this.tree.setUseHashlookup(true);
        final SpringExplorerAdaptingContentProvider treeContentProvider = new SpringExplorerAdaptingContentProvider();
        this.tree.setContentProvider((IContentProvider)treeContentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)new SpringExplorerAdaptingLabelProvider());
        this.tree.setSorter(new ViewerSorter());
        this.tree.setInput((Object)IDEWorkbenchPlugin.getPluginWorkspace().getRoot());
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.tree.getControl().setLayoutData((Object)data);
        this.tree.getControl().setFont(font);
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SpringWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                final Object element = event.getElement();
                if (!SpringWorkingSetPage.this.tree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)SpringWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SpringWorkingSetPage.this.setSubtreeChecked(element, SpringWorkingSetPage.this.tree.getChecked(element), false);
                        }
                    });
                }
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText("Select &All");
        selectAllButton.setToolTipText("Select all of theses resource for this working set.");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpringWorkingSetPage.this.tree.setCheckedElements(treeContentProvider.getElements(SpringWorkingSetPage.this.tree.getInput()));
                SpringWorkingSetPage.this.validateInput();
            }
        });
        selectAllButton.setFont(font);
        this.setButtonLayoutData(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText("Dese&lect All");
        deselectAllButton.setToolTipText("Deselect all of these resources for this working set.");
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpringWorkingSetPage.this.tree.setCheckedElements(new Object[0]);
                SpringWorkingSetPage.this.validateInput();
            }
        });
        deselectAllButton.setFont(font);
        this.setButtonLayoutData(deselectAllButton);
        this.initializeCheckedState();
        if (this.workingSet != null) {
            this.text.setText(this.workingSet.getName());
        }
        this.setPageComplete(false);
    }

    private void findCheckedResources(List<IAdaptable> checkedResources, Object[] checkedElements) {
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] children;
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof IFile && (children = this.contentProvider.getChildren(checkedElement)) != null && children.length == 1) {
                checkedElement = children[0];
            }
            if (this.isValidPersistableElement(checkedElement)) {
                checkedResources.add((IAdaptable)checkedElement);
            }
            ++n2;
        }
    }

    private boolean isValidPersistableElement(Object checkedElement) {
        return checkedElement instanceof IAdaptable && ((IAdaptable)checkedElement).getAdapter(IPersistableElement.class) != null;
    }

    public void finish() {
        ArrayList<IAdaptable> resources = new ArrayList<IAdaptable>(10);
        this.findCheckedResources(resources, this.tree.getCheckedElements());
        if (this.workingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = workingSetManager.createWorkingSet(this.getWorkingSetName(), resources.toArray(new IAdaptable[resources.size()]));
        } else {
            this.workingSet.setName(this.getWorkingSetName());
            this.workingSet.setElements(resources.toArray(new IAdaptable[resources.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    private String getWorkingSetName() {
        return this.text.getText();
    }

    private void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                boolean state = event.getChecked();
                SpringWorkingSetPage.this.setSubtreeChecked(event.getElement(), state, true);
                SpringWorkingSetPage.this.updateParentState(event.getElement());
                SpringWorkingSetPage.this.validateInput();
            }
        });
    }

    private void initializeCheckedState() {
        if (this.workingSet == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] items = SpringWorkingSetPage.this.workingSet.getElements();
                SpringWorkingSetPage.this.tree.setCheckedElements(items);
                int i = 0;
                while (i < items.length) {
                    Object item = items[i];
                    IResource resource = null;
                    resource = item instanceof IResource ? (IResource)item : (IResource)item.getAdapter(IResource.class);
                    if (resource != null && !resource.isAccessible()) {
                        IProject project = resource.getProject();
                        if (!SpringWorkingSetPage.this.tree.getChecked((Object)project)) {
                            SpringWorkingSetPage.this.tree.setGrayChecked((Object)project, true);
                        }
                    } else if (resource != null) {
                        SpringWorkingSetPage.this.updateParentState(resource);
                    } else {
                        SpringWorkingSetPage.this.updateParentState(item);
                    }
                    ++i;
                }
            }
        });
    }

    public void setSelection(IWorkingSet workingSet) {
        if (workingSet == null) {
            throw new IllegalArgumentException("Working set must not be null");
        }
        this.workingSet = workingSet;
        if (this.getShell() != null && this.text != null) {
            this.firstCheck = true;
            this.initializeCheckedState();
            this.text.setText(workingSet.getName());
        }
    }

    private void setSubtreeChecked(Object container, boolean state, boolean checkExpandedState) {
        Object[] members = this.contentProvider.getChildren(container);
        int i = members.length - 1;
        while (i >= 0) {
            boolean elementGrayChecked;
            Object element = members[i];
            boolean bl = elementGrayChecked = this.tree.getGrayed(element) || this.tree.getChecked(element);
            if (state) {
                this.tree.setChecked(element, true);
                this.tree.setGrayed(element, false);
            } else {
                this.tree.setGrayChecked(element, false);
            }
            if (state || elementGrayChecked) {
                this.setSubtreeChecked(element, state, true);
            }
            --i;
        }
    }

    private void updateParentState(Object child) {
        if (child == null || this.contentProvider.getParent(child) == null) {
            return;
        }
        Object parent = this.contentProvider.getParent(child);
        boolean childChecked = false;
        Object[] members = this.contentProvider.getChildren(parent);
        int i = members.length - 1;
        while (i >= 0) {
            if (this.tree.getChecked(members[i]) || this.tree.getGrayed(members[i])) {
                childChecked = true;
                break;
            }
            --i;
        }
        this.tree.setGrayChecked(parent, childChecked);
        this.updateParentState(parent);
    }

    private void validateInput() {
        String errorMessage = null;
        String infoMessage = null;
        String newText = this.text.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = " The name must not have a leading or trailing whitespace.";
        } else if (this.firstCheck) {
            this.firstCheck = false;
            return;
        }
        if (newText.equals("")) {
            errorMessage = " The name must not be empty.";
        }
        if (!(errorMessage != null || this.workingSet != null && newText.equals(this.workingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = " A working set with the same name already exists.";
                }
                ++i;
            }
        }
        if (infoMessage == null && this.tree.getCheckedElements().length == 0) {
            infoMessage = " No resources selected.";
        }
        this.setMessage(infoMessage, 1);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public class SpringExplorerAdaptingContentProvider
    implements ITreeContentProvider {
        private Set<ITreeContentProvider> contentProviders = WorkingSetUtils.getContentProvider();
        private ITreeContentProvider rootContentProvider = new SpringNavigatorContentProvider();

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            HashSet<Object> children = new HashSet<Object>();
            for (ITreeContentProvider contentProvider : this.contentProviders) {
                children.addAll(Arrays.asList(contentProvider.getChildren(parentElement)));
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            for (ITreeContentProvider contentProvider : this.contentProviders) {
                Object parent = contentProvider.getParent(element);
                if (parent == null) continue;
                return parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            HashSet<Object> children = new HashSet<Object>();
            for (ITreeContentProvider contentProvider : this.contentProviders) {
                children.addAll(Arrays.asList(contentProvider.getChildren(element)));
            }
            return children.size() > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof WorkspaceRoot) {
                return this.rootContentProvider.getElements(inputElement);
            }
            HashSet<Object> children = new HashSet<Object>();
            for (ITreeContentProvider contentProvider : this.contentProviders) {
                children.addAll(Arrays.asList(contentProvider.getElements(inputElement)));
            }
            return children.toArray();
        }
    }

    private class SpringExplorerAdaptingLabelProvider
    implements ILabelProvider {
        private Set<IElementSpecificLabelProvider> labelProviders = WorkingSetUtils.getLabelProvider();
        private ILabelProvider rootLabelProviders = new SpringNavigatorLabelProvider();

        private SpringExplorerAdaptingLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ISpringProject) {
                return this.rootLabelProviders.getImage(element);
            }
            for (IElementSpecificLabelProvider labelProvider : this.labelProviders) {
                if (!labelProvider.supportsElement(element)) continue;
                return labelProvider.getImage(element);
            }
            return this.rootLabelProviders.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ISpringProject) {
                return this.rootLabelProviders.getText(element);
            }
            for (IElementSpecificLabelProvider labelProvider : this.labelProviders) {
                if (!labelProvider.supportsElement(element)) continue;
                return labelProvider.getText(element);
            }
            return this.rootLabelProviders.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

