/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.preferences.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferencesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.graphics.RGB;

class PreferencesManagerImpl
implements IPreferencesManager {
    private IPreferences preferences;
    private IPreferenceStore storePreferencesStore = PMDPlugin.getDefault().getPreferenceStore();
    private IPreferenceStore loadPreferencesStore;
    private RuleSet ruleSet;
    private static final Logger log = Logger.getLogger(PreferencesManagerImpl.class);
    private static final String PROJECT_BUILD_PATH_ENABLED = "net.sourceforge.pmd.eclipse.plugin.project_build_path_enabled";
    private static final String PMD_PERSPECTIVE_ENABLED = "net.sourceforge.pmd.eclipse.plugin.pmd_perspective_enabled";
    private static final String PMD_CHECK_AFTER_SAVE_ENABLED = "net.sourceforge.pmd.eclipse.plugin.pmd_check_after_save_enabled";
    private static final String MAX_VIOLATIONS_PFPR = "net.sourceforge.pmd.eclipse.plugin.max_violations_pfpr";
    private static final String REVIEW_ADDITIONAL_COMMENT = "net.sourceforge.pmd.eclipse.plugin.review_additional_comment";
    private static final String REVIEW_PMD_STYLE_ENABLED = "net.sourceforge.pmd.eclipse.plugin.review_pmd_style_enabled";
    private static final String PMD_USE_CUSTOM_PRIORITY_NAMES = "net.sourceforge.pmd.eclipse.plugin.use_custom_priority_names";
    private static final String MIN_TILE_SIZE = "net.sourceforge.pmd.eclipse.plugin.min_tile_size";
    private static final String LOG_FILENAME = "net.sourceforge.pmd.eclipse.plugin.log_filename";
    private static final String LOG_LEVEL = "net.sourceforge.pmd.eclipse.plugin.log_level";
    private static final String GLOBAL_RULE_MANAGEMENT = "net.sourceforge.pmd.eclipse.plugin.globalRuleManagement";
    private static final String ACTIVE_RULES = "net.sourceforge.pmd.eclipse.plugin.active_rules";
    private static final String ACTIVE_RENDERERS = "net.sourceforge.pmd.eclipse.plugin.active_renderers";
    private static final String ACTIVE_EXCLUSIONS = "net.sourceforge.pmd.eclipse.plugin.active_exclusions";
    private static final String ACTIVE_INCLUSIONS = "net.sourceforge.pmd.eclipse.plugin.active_inclusions";
    private static final String OLD_PREFERENCE_PREFIX = "net.sourceforge.pmd.runtime";
    private static final String OLD_PREFERENCE_LOCATION = "/.metadata/.plugins/org.eclipse.core.runtime/.settings/net.sourceforge.pmd.runtime.prefs";
    public static final String NEW_PREFERENCE_LOCATION = "/.metadata/.plugins/org.eclipse.core.runtime/.settings/net.sourceforge.pmd.eclipse.plugin.prefs";
    private static final String PREFERENCE_RULESET_FILE = "/ruleset.xml";
    private static final Map<RulePriority, PriorityDescriptor> DefaultDescriptorsByPriority = new HashMap<RulePriority, PriorityDescriptor>(5);
    private static final Map<RulePriority, String> StoreKeysByPriority = new HashMap<RulePriority, String>(5);

    static {
        DefaultDescriptorsByPriority.put(RulePriority.HIGH, new PriorityDescriptor(RulePriority.HIGH, "view.filter.priority.1", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(255, 0, 0), 13));
        DefaultDescriptorsByPriority.put(RulePriority.MEDIUM_HIGH, new PriorityDescriptor(RulePriority.MEDIUM_HIGH, "view.filter.priority.2", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(0, 255, 255), 13));
        DefaultDescriptorsByPriority.put(RulePriority.MEDIUM, new PriorityDescriptor(RulePriority.MEDIUM, "view.filter.priority.3", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(0, 255, 0), 13));
        DefaultDescriptorsByPriority.put(RulePriority.MEDIUM_LOW, new PriorityDescriptor(RulePriority.MEDIUM_LOW, "view.filter.priority.4", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(255, 0, 255), 13));
        DefaultDescriptorsByPriority.put(RulePriority.LOW, new PriorityDescriptor(RulePriority.LOW, "view.filter.priority.5", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(0, 0, 255), 13));
        StoreKeysByPriority.put(RulePriority.HIGH, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_1");
        StoreKeysByPriority.put(RulePriority.MEDIUM_HIGH, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_2");
        StoreKeysByPriority.put(RulePriority.MEDIUM, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_3");
        StoreKeysByPriority.put(RulePriority.MEDIUM_LOW, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_4");
        StoreKeysByPriority.put(RulePriority.LOW, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_5");
    }

    PreferencesManagerImpl() {
    }

    @Override
    public PriorityDescriptor defaultDescriptorFor(RulePriority priority) {
        return DefaultDescriptorsByPriority.get(priority);
    }

    @Override
    public IPreferences loadPreferences() {
        if (this.preferences == null) {
            this.reloadPreferences();
        }
        return this.preferences;
    }

    @Override
    public IPreferences reloadPreferences() {
        this.initLoadPreferencesStore();
        PreferencesFactoryImpl factory = new PreferencesFactoryImpl();
        this.preferences = factory.newPreferences(this);
        this.loadProjectBuildPathEnabled();
        this.loadPmdPerspectiveEnabled();
        this.loadCheckAfterSaveEnabled();
        this.loadUseCustomPriorityNames();
        this.loadMaxViolationsPerFilePerRule();
        this.loadReviewAdditionalComment();
        this.loadReviewPmdStyleEnabled();
        this.loadMinTileSize();
        this.loadLogFileName();
        this.loadLogLevel();
        this.loadGlobalRuleManagement();
        this.loadActiveRules();
        this.loadActiveReportRenderers();
        this.loadActiveExclusions();
        this.loadActiveInclusions();
        this.loadRulePriorityDescriptors();
        return this.preferences;
    }

    private void initLoadPreferencesStore() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = root.getLocation();
        File newPrefs = new File(path.append(NEW_PREFERENCE_LOCATION).toString());
        File oldPrefs = new File(path.append(OLD_PREFERENCE_LOCATION).toString());
        this.loadPreferencesStore = this.storePreferencesStore;
        if (!newPrefs.exists() && oldPrefs.exists()) {
            try {
                Properties props = new Properties();
                FileInputStream in = new FileInputStream(oldPrefs);
                props.load(in);
                in.close();
                this.loadPreferencesStore = new PreferenceStore();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.startsWith(OLD_PREFERENCE_PREFIX)) {
                        key = key.replaceFirst(OLD_PREFERENCE_PREFIX, "net.sourceforge.pmd.eclipse.plugin");
                    }
                    this.loadPreferencesStore.putValue(key, (String)entry.getValue());
                }
            }
            catch (IOException ioe) {
                PMDPlugin.getDefault().logError("IOException in loading old format preferences", ioe);
                this.loadPreferencesStore = this.storePreferencesStore;
            }
        }
    }

    @Override
    public void storePreferences(IPreferences thePreferences) {
        this.preferences = thePreferences;
        this.storeProjectBuildPathEnabled();
        this.storePmdPerspectiveEnabled();
        this.storeCheckAfterSaveEnabled();
        this.storeUseCustomPriorityNames();
        this.storeMaxViolationsPerFilePerRule();
        this.storeReviewAdditionalComment();
        this.storeReviewPmdStyleEnabled();
        this.storeMinTileSize();
        this.storeLogFileName();
        this.storeLogLevel();
        this.storeGlobalRuleManagement();
        this.storeActiveRules();
        this.storeActiveReportRenderers();
        this.storeActiveExclusions();
        this.storeActiveInclusions();
        this.storePriorityDescriptors();
    }

    @Override
    public RuleSet getRuleSet() {
        if (this.ruleSet == null) {
            this.ruleSet = this.getRuleSetFromStateLocation();
        }
        return this.ruleSet;
    }

    @Override
    public void setRuleSet(RuleSet newRuleSet) {
        this.updateConfiguredProjects(newRuleSet);
        this.ruleSet = newRuleSet;
        this.storeRuleSetInStateLocation(this.ruleSet);
    }

    private void loadProjectBuildPathEnabled() {
        this.loadPreferencesStore.setDefault(PROJECT_BUILD_PATH_ENABLED, true);
        this.preferences.setProjectBuildPathEnabled(this.loadPreferencesStore.getBoolean(PROJECT_BUILD_PATH_ENABLED));
    }

    private void loadPmdPerspectiveEnabled() {
        this.loadPreferencesStore.setDefault(PMD_PERSPECTIVE_ENABLED, true);
        this.preferences.setPmdPerspectiveEnabled(this.loadPreferencesStore.getBoolean(PMD_PERSPECTIVE_ENABLED));
    }

    private void loadCheckAfterSaveEnabled() {
        this.loadPreferencesStore.setDefault(PMD_CHECK_AFTER_SAVE_ENABLED, false);
        this.preferences.isCheckAfterSaveEnabled(this.loadPreferencesStore.getBoolean(PMD_CHECK_AFTER_SAVE_ENABLED));
    }

    private void loadUseCustomPriorityNames() {
        this.loadPreferencesStore.setDefault(PMD_USE_CUSTOM_PRIORITY_NAMES, true);
        this.preferences.useCustomPriorityNames(this.loadPreferencesStore.getBoolean(PMD_USE_CUSTOM_PRIORITY_NAMES));
    }

    private void loadMaxViolationsPerFilePerRule() {
        this.loadPreferencesStore.setDefault(MAX_VIOLATIONS_PFPR, 5);
        this.preferences.setMaxViolationsPerFilePerRule(this.loadPreferencesStore.getInt(MAX_VIOLATIONS_PFPR));
    }

    private void loadReviewAdditionalComment() {
        this.loadPreferencesStore.setDefault(REVIEW_ADDITIONAL_COMMENT, "by {0} on {1}");
        this.preferences.setReviewAdditionalComment(this.loadPreferencesStore.getString(REVIEW_ADDITIONAL_COMMENT));
    }

    private void loadReviewPmdStyleEnabled() {
        this.loadPreferencesStore.setDefault(REVIEW_PMD_STYLE_ENABLED, true);
        this.preferences.setReviewPmdStyleEnabled(this.loadPreferencesStore.getBoolean(REVIEW_PMD_STYLE_ENABLED));
    }

    private void loadMinTileSize() {
        this.loadPreferencesStore.setDefault(MIN_TILE_SIZE, 25);
        this.preferences.setMinTileSize(this.loadPreferencesStore.getInt(MIN_TILE_SIZE));
    }

    private void loadLogFileName() {
        this.loadPreferencesStore.setDefault(LOG_FILENAME, IPreferences.LOG_FILENAME_DEFAULT);
        this.preferences.setLogFileName(this.loadPreferencesStore.getString(LOG_FILENAME));
    }

    private void loadLogLevel() {
        this.loadPreferencesStore.setDefault(LOG_LEVEL, IPreferences.LOG_LEVEL.toString());
        this.preferences.setLogLevel(Level.toLevel((String)this.loadPreferencesStore.getString(LOG_LEVEL)));
    }

    private void loadGlobalRuleManagement() {
        this.loadPreferencesStore.setDefault(GLOBAL_RULE_MANAGEMENT, false);
        this.preferences.setGlobalRuleManagement(this.loadPreferencesStore.getBoolean(GLOBAL_RULE_MANAGEMENT));
    }

    private void loadActiveRules() {
        this.loadPreferencesStore.setDefault(ACTIVE_RULES, this.preferences.getDefaultActiveRules());
        this.preferences.setActiveRuleNames(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(ACTIVE_RULES), ","));
    }

    private void loadActiveReportRenderers() {
        this.loadPreferencesStore.setDefault(ACTIVE_RENDERERS, "text");
        this.preferences.activeReportRenderers(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(ACTIVE_RENDERERS), ","));
    }

    private void loadActiveExclusions() {
        this.loadPreferencesStore.setDefault(ACTIVE_EXCLUSIONS, "");
        this.preferences.activeExclusionPatterns(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(ACTIVE_EXCLUSIONS), ","));
    }

    private void loadActiveInclusions() {
        this.loadPreferencesStore.setDefault(ACTIVE_INCLUSIONS, "");
        this.preferences.activeInclusionPatterns(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(ACTIVE_INCLUSIONS), ","));
    }

    private void loadRulePriorityDescriptors() {
        for (Map.Entry<RulePriority, String> entry : StoreKeysByPriority.entrySet()) {
            PriorityDescriptor desc = this.defaultDescriptorFor(entry.getKey());
            this.loadPreferencesStore.setDefault(entry.getValue(), desc.storeString());
            String storeKey = StoreKeysByPriority.get(entry.getKey());
            this.preferences.setPriorityDescriptor(entry.getKey(), PriorityDescriptor.from(this.loadPreferencesStore.getString(storeKey)));
        }
    }

    private static Set<String> asStringSet(String delimitedString, String delimiter) {
        String[] values = delimitedString.split(delimiter);
        HashSet<String> valueSet = new HashSet<String>(values.length);
        int i = 0;
        while (i < values.length) {
            String name = values[i].trim();
            if (!StringUtil.isEmpty((String)name)) {
                valueSet.add(name);
            }
            ++i;
        }
        return valueSet;
    }

    private static String asDelimitedString(Set<String> values, String delimiter) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(delimiter).append(value);
        }
        return sb.toString();
    }

    private void storeGlobalRuleManagement() {
        this.storePreferencesStore.setValue(GLOBAL_RULE_MANAGEMENT, this.preferences.getGlobalRuleManagement());
    }

    private void storeActiveRules() {
        this.storePreferencesStore.setValue(ACTIVE_RULES, PreferencesManagerImpl.asDelimitedString(this.preferences.getActiveRuleNames(), ","));
    }

    private void storeActiveReportRenderers() {
        this.storePreferencesStore.setValue(ACTIVE_RENDERERS, PreferencesManagerImpl.asDelimitedString(this.preferences.activeReportRenderers(), ","));
    }

    private void storeActiveExclusions() {
        this.storePreferencesStore.setValue(ACTIVE_EXCLUSIONS, PreferencesManagerImpl.asDelimitedString(this.preferences.activeExclusionPatterns(), ","));
    }

    private void storeActiveInclusions() {
        this.storePreferencesStore.setValue(ACTIVE_INCLUSIONS, PreferencesManagerImpl.asDelimitedString(this.preferences.activeInclusionPatterns(), ","));
    }

    private void storeProjectBuildPathEnabled() {
        this.storePreferencesStore.setValue(PROJECT_BUILD_PATH_ENABLED, this.preferences.isProjectBuildPathEnabled());
    }

    private void storeCheckAfterSaveEnabled() {
        this.storePreferencesStore.setValue(PMD_CHECK_AFTER_SAVE_ENABLED, this.preferences.isCheckAfterSaveEnabled());
    }

    private void storeUseCustomPriorityNames() {
        this.storePreferencesStore.setValue(PMD_USE_CUSTOM_PRIORITY_NAMES, this.preferences.useCustomPriorityNames());
    }

    private void storePmdPerspectiveEnabled() {
        this.storePreferencesStore.setValue(PMD_PERSPECTIVE_ENABLED, this.preferences.isPmdPerspectiveEnabled());
    }

    private void storeMaxViolationsPerFilePerRule() {
        this.storePreferencesStore.setValue(MAX_VIOLATIONS_PFPR, this.preferences.getMaxViolationsPerFilePerRule());
    }

    private void storeReviewAdditionalComment() {
        this.storePreferencesStore.setValue(REVIEW_ADDITIONAL_COMMENT, this.preferences.getReviewAdditionalComment());
    }

    private void storeReviewPmdStyleEnabled() {
        this.storePreferencesStore.setValue(REVIEW_PMD_STYLE_ENABLED, this.preferences.isReviewPmdStyleEnabled());
    }

    private void storeMinTileSize() {
        this.storePreferencesStore.setValue(MIN_TILE_SIZE, this.preferences.getMinTileSize());
    }

    private void storeLogFileName() {
        this.storePreferencesStore.setValue(LOG_FILENAME, this.preferences.getLogFileName());
    }

    private void storeLogLevel() {
        this.storePreferencesStore.setValue(LOG_LEVEL, this.preferences.getLogLevel().toString());
    }

    private void storePriorityDescriptors() {
        for (Map.Entry<RulePriority, String> entry : StoreKeysByPriority.entrySet()) {
            PriorityDescriptor desc = this.preferences.getPriorityDescriptor(entry.getKey());
            this.storePreferencesStore.setValue(entry.getValue(), desc.storeString());
        }
    }

    private RuleSet getRuleSetFromStateLocation() {
        RuleSet preferedRuleSet = null;
        RuleSetFactory factory = new RuleSetFactory();
        IPath ruleSetLocation = PMDPlugin.getDefault().getStateLocation().append(PREFERENCE_RULESET_FILE);
        File ruleSetFile = new File(ruleSetLocation.toOSString());
        if (ruleSetFile.exists()) {
            try {
                preferedRuleSet = factory.createRuleSet(ruleSetLocation.toOSString());
            }
            catch (RuntimeException e) {
                PMDPlugin.getDefault().showError("Runtime Exception when loading stored ruleset file. Falling back to default ruleset.", e);
            }
            catch (RuleSetNotFoundException e) {
                PMDPlugin.getDefault().showError("RuleSet Not Found Exception when loading stored ruleset file. Falling back to default ruleset.", e);
            }
        }
        if (preferedRuleSet == null) {
            preferedRuleSet = new RuleSet();
            preferedRuleSet.setName("pmd-eclipse");
            preferedRuleSet.setDescription("PMD Plugin preferences rule set");
            IRuleSetManager ruleSetManager = PMDPlugin.getDefault().getRuleSetManager();
            for (RuleSet ruleSet : ruleSetManager.getDefaultRuleSets()) {
                preferedRuleSet.addRuleSetByReference(ruleSet, false);
            }
        }
        return preferedRuleSet;
    }

    private Set<Rule> getNewRules(RuleSet newRuleSet) {
        HashSet<Rule> addedRules = new HashSet<Rule>();
        for (Rule rule : newRuleSet.getRules()) {
            if (this.ruleSet.getRuleByName(rule.getName()) != null) continue;
            addedRules.add(rule);
        }
        return addedRules;
    }

    private void updateConfiguredProjects(RuleSet updatedRuleSet) {
        IProject[] projects;
        log.debug((Object)"Updating configured projects");
        RuleSet addedRuleSet = new RuleSet();
        for (Rule rule : this.getNewRules(updatedRuleSet)) {
            addedRuleSet.addRule(rule);
        }
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                try {
                    IProjectProperties properties = PMDPlugin.getDefault().loadProjectProperties(project);
                    RuleSet projectRuleSet = properties.getProjectRuleSet();
                    if (projectRuleSet != null) {
                        projectRuleSet.addRuleSet(addedRuleSet);
                        projectRuleSet.setExcludePatterns(new ArrayList(updatedRuleSet.getExcludePatterns()));
                        projectRuleSet.setIncludePatterns(new ArrayList(updatedRuleSet.getIncludePatterns()));
                        properties.setProjectRuleSet(projectRuleSet);
                        properties.sync();
                    }
                }
                catch (PropertiesException e) {
                    PMDPlugin.getDefault().logError("Unable to add new rules for project: " + project, e);
                }
            }
            ++n2;
        }
    }

    private void storeRuleSetInStateLocation(RuleSet ruleSet) {
        block7: {
            FileOutputStream out = null;
            PMDPlugin plugin = PMDPlugin.getDefault();
            try {
                IPath ruleSetLocation = plugin.getStateLocation().append(PREFERENCE_RULESET_FILE);
                out = new FileOutputStream(ruleSetLocation.toOSString());
                IRuleSetWriter writer = plugin.getRuleSetWriter();
                writer.write(out, ruleSet);
                out.flush();
            }
            catch (IOException e) {
                plugin.logError("IO Exception when storing ruleset in state location", e);
                IOUtil.closeQuietly(out);
                break block7;
            }
            catch (WriterException e) {
                try {
                    plugin.logError("General PMD Eclipse Exception when storing ruleset in state location", e);
                    break block7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.closeQuietly(out);
                }
            }
            IOUtil.closeQuietly(out);
        }
    }
}

