/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;

public class RuleSetUtil {
    private RuleSetUtil() {
    }

    public static RuleSet newCopyOf(RuleSet original) {
        RuleSet rs = new RuleSet();
        rs.setName(original.getName());
        rs.setDescription(original.getDescription());
        rs.setFileName(original.getFileName());
        rs.setExcludePatterns((Collection)original.getExcludePatterns());
        rs.setIncludePatterns((Collection)original.getIncludePatterns());
        rs.addRuleSet(original);
        return rs;
    }

    public static void retainOnly(RuleSet ruleSet, Set<String> wantedRuleNames) {
        Collection rules = ruleSet.getRules();
        ArrayList ruleCopy = new ArrayList(rules.size());
        ruleCopy.addAll(rules);
        for (Rule rule : ruleCopy) {
            if (wantedRuleNames.contains(rule.getName())) continue;
            rules.remove(rule);
        }
    }

    public static void remove(RuleSet ruleSet, Set<String> unwantedRuleNames) {
        Collection rules = ruleSet.getRules();
        ArrayList ruleCopy = new ArrayList(rules.size());
        ruleCopy.addAll(rules);
        for (Rule rule : ruleCopy) {
            if (!unwantedRuleNames.contains(rule.getName())) continue;
            rules.remove(rule);
        }
    }
}

