/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.ProjectRecord;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;

public class RootRecord
extends AbstractPMDRecord {
    private final IWorkspaceRoot workspaceRoot;
    private AbstractPMDRecord[] children;

    public RootRecord(IWorkspaceRoot root) {
        if (root == null) {
            throw new IllegalArgumentException("roor cannot be null");
        }
        this.workspaceRoot = root;
        this.children = this.createChildren();
    }

    @Override
    public AbstractPMDRecord getParent() {
        return this;
    }

    @Override
    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    @Override
    public IResource getResource() {
        return this.workspaceRoot;
    }

    @Override
    protected final AbstractPMDRecord[] createChildren() {
        IProject[] projects = this.workspaceRoot.getProjects();
        ArrayList<ProjectRecord> projectList = new ArrayList<ProjectRecord>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            projectList.add(new ProjectRecord(project, this));
            ++n2;
        }
        return projectList.toArray(new AbstractPMDRecord[projectList.size()]);
    }

    @Override
    public AbstractPMDRecord addResource(IResource resource) {
        return resource instanceof IProject ? this.addProject((IProject)resource) : null;
    }

    @Override
    public AbstractPMDRecord removeResource(IResource resource) {
        return resource instanceof IProject ? this.removeProject((IProject)resource) : null;
    }

    @Override
    public String getName() {
        return this.workspaceRoot.getName();
    }

    @Override
    public int getResourceType() {
        return 8;
    }

    private ProjectRecord addProject(IProject project) {
        ProjectRecord addedProject = null;
        if (project.isOpen()) {
            List<AbstractPMDRecord> projects = this.getChildrenAsList();
            ProjectRecord projectRec = new ProjectRecord(project, this);
            projects.add(projectRec);
            this.children = new AbstractPMDRecord[projects.size()];
            projects.toArray(this.children);
            addedProject = projectRec;
        }
        return addedProject;
    }

    private ProjectRecord removeProject(IProject project) {
        ProjectRecord removedProject = null;
        List<AbstractPMDRecord> projects = this.getChildrenAsList();
        int k = 0;
        while (k < projects.size() && removedProject == null) {
            ProjectRecord projectRec = (ProjectRecord)projects.get(k);
            IProject proj = (IProject)projectRec.getResource();
            if (proj.equals((Object)project)) {
                projects.remove(projectRec);
                this.children = new AbstractPMDRecord[projects.size()];
                projects.toArray(this.children);
                removedProject = projectRec;
            }
            ++k;
        }
        return removedProject;
    }

    @Override
    public int getNumberOfViolationsToPriority(int prio, boolean invertMarkerAndFileRecords) {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getNumberOfViolationsToPriority(prio, invertMarkerAndFileRecords);
            ++n2;
        }
        return number;
    }

    @Override
    public int getLOC() {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getLOC();
            ++n2;
        }
        return number;
    }

    @Override
    public int getNumberOfMethods() {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getNumberOfMethods();
            ++n2;
        }
        return number;
    }
}

