/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.preferences.PMDPreferencePage;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class RuleCellModifier
implements ICellModifier {
    private TableViewer tableViewer;

    public RuleCellModifier(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public boolean canModify(Object element, String property) {
        return property.equalsIgnoreCase("priority") || property.equalsIgnoreCase("description");
    }

    public Object getValue(Object element, String property) {
        Object result = null;
        if (element instanceof Rule) {
            Rule rule = (Rule)element;
            if (property.equalsIgnoreCase("language")) {
                result = rule.getLanguage().getShortName();
            } else if (property.equalsIgnoreCase("ruleSetname")) {
                result = rule.getRuleSetName();
            } else if (property.equalsIgnoreCase("ruleName")) {
                result = rule.getName();
            } else if (property.equalsIgnoreCase("priority")) {
                result = rule.getPriority().getPriority() - 1;
            } else if (property.equalsIgnoreCase("description")) {
                result = rule.getDescription();
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        try {
            if (item.getData() instanceof Rule) {
                Rule rule = (Rule)item.getData();
                if (property.equalsIgnoreCase("priority")) {
                    rule.setPriority(RulePriority.valueOf((int)((Integer)value + 1)));
                    PMDPreferencePage.getActiveInstance().setModified(true);
                    this.tableViewer.refresh();
                } else if (property.equalsIgnoreCase("description")) {
                    rule.setDescription((String)value);
                    PMDPreferencePage.getActiveInstance().setModified(true);
                    this.tableViewer.refresh();
                }
            }
        }
        catch (Throwable t) {
            PMDPlugin.getDefault().logError("Exception when notifying a modification in a cell of the rule table in the preference page", t);
        }
    }
}

