/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleDupeChecker;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleLabelProvider;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RuleSetSelectionDialog
extends Dialog {
    private Combo inputCombo;
    private Button referenceButton;
    private Button copyButton;
    private String importedRuleSetName;
    private RuleSet selectedRuleSet;
    private boolean importByReference;
    private Label warningField;
    private CheckboxTableViewer ruleTable;
    private RuleSet checkedRules;
    private final RuleDupeChecker dupeChecker;
    private final String title;
    private final RuleSet[] ruleSets;
    private final String[] ruleSetNames;
    private final RuleColumnDescriptor[] columns;

    private static String labelFor(RuleSet rs) {
        Collection rules = rs.getRules();
        String lang = ((Rule)rules.iterator().next()).getLanguage().getShortName();
        return String.valueOf(lang) + " - " + rs.getName() + "  (" + rules.size() + ")";
    }

    public RuleSetSelectionDialog(Shell parent, String theTitle, RuleColumnDescriptor[] theColumns, RuleDupeChecker theDupeChecker) {
        super(parent);
        this.title = theTitle;
        this.dupeChecker = theDupeChecker;
        this.columns = theColumns;
        this.setShellStyle(this.getShellStyle() | 0x10);
        Set<RuleSet> registeredRuleSets = PMDPlugin.getDefault().getRuleSetManager().getRegisteredRuleSets();
        TreeSet<RuleSet> sortedRuleSets = new TreeSet<RuleSet>(new Comparator<RuleSet>(){

            @Override
            public int compare(RuleSet ruleSet1, RuleSet ruleSet2) {
                return RuleSetSelectionDialog.labelFor(ruleSet1).compareToIgnoreCase(RuleSetSelectionDialog.labelFor(ruleSet2));
            }
        });
        sortedRuleSets.addAll(registeredRuleSets);
        this.ruleSets = new RuleSet[sortedRuleSets.size()];
        this.ruleSetNames = new String[sortedRuleSets.size()];
        Iterator i = sortedRuleSets.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.ruleSets[index] = (RuleSet)i.next();
            this.ruleSetNames[index] = this.ruleSets[index].getName();
            if (!this.ruleSets[index].getRules().isEmpty()) {
                this.ruleSetNames[index] = RuleSetSelectionDialog.labelFor(this.ruleSets[index]);
            }
            ++index;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(500, 400);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgArea = new Composite(parent, 0);
        dlgArea.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        dlgArea.setLayout((Layout)gridLayout);
        Label enterRuleSetLabel = this.buildLabel(dlgArea, this.getMessage("preference.rulesetselection.label.enter_ruleset"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        enterRuleSetLabel.setLayoutData((Object)data);
        this.inputCombo = this.buildInputCombo(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.inputCombo.setLayoutData((Object)data);
        this.buildBrowseButton(dlgArea);
        this.referenceButton = this.buildReferenceButton(dlgArea);
        this.copyButton = this.buildCopyButton(dlgArea);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.copyButton.setLayoutData((Object)data);
        this.ruleTable = CheckboxTableViewer.newCheckList((Composite)dlgArea, (int)2048);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.ruleTable.getTable().setLayoutData((Object)data);
        this.setupRuleTable();
        this.warningField = new Label(dlgArea, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        this.warningField.setForeground(parent.getDisplay().getSystemColor(3));
        this.warningField.setLayoutData((Object)data);
        this.getShell().setText(this.title);
        return dlgArea;
    }

    protected void createCheckBoxColumn(Table table) {
        TableColumn tc = new TableColumn(table, 0);
        tc.setWidth(30);
        tc.setResizable(false);
        tc.pack();
    }

    private void setupRuleTable() {
        Table tbl = this.ruleTable.getTable();
        tbl.setLinesVisible(true);
        tbl.setHeaderVisible(true);
        this.ruleTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                RuleSet rs = RuleSetSelectionDialog.this.selectedRuleset();
                return rs == null ? new Object[]{} : rs.getRules().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.ruleTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RuleSetSelectionDialog.this.ruleChecked();
            }
        });
        this.createCheckBoxColumn(tbl);
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].newTableColumnFor(tbl, i + 1, null, null);
            ++i;
        }
        this.ruleTable.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider(this.columns));
    }

    private void checkNonDupes() {
        ArrayList<Rule> nonDupes = new ArrayList<Rule>();
        TableItem[] tableItemArray = this.ruleTable.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Rule rule = (Rule)item.getData();
            if (!this.dupeChecker.isDuplicate(rule)) {
                nonDupes.add(rule);
            }
            ++n2;
        }
        this.ruleTable.setCheckedElements(nonDupes.toArray());
    }

    public void create() {
        super.create();
        this.updateControls();
    }

    private Label buildLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private Combo buildInputCombo(Composite parent) {
        Combo combo = new Combo(parent, 0);
        combo.setItems(this.ruleSetNames);
        combo.setText("");
        combo.setToolTipText(this.getMessage("preference.rulesetselection.tooltip.ruleset"));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleSetSelectionDialog.this.ruleSetChanged();
            }
        });
        return combo;
    }

    private Button buildBrowseButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(this.getMessage("preference.rulesetselection.button.browse"));
        button.setEnabled(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(RuleSetSelectionDialog.this.getShell(), 4096);
                String fileName = dialog.open();
                if (StringUtil.isNotEmpty((String)fileName)) {
                    RuleSetSelectionDialog.this.inputCombo.setText(fileName);
                    RuleSetSelectionDialog.this.ruleSetChanged();
                }
            }
        });
        return button;
    }

    private Button buildReferenceButton(Composite parent) {
        Button button = new Button(parent, 16);
        button.setText(this.getMessage("preference.rulesetselection.button.reference"));
        button.setSelection(true);
        this.importByReference = true;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleSetSelectionDialog.this.importByReference = true;
            }
        });
        return button;
    }

    private Button buildCopyButton(Composite parent) {
        Button button = new Button(parent, 16);
        button.setText(this.getMessage("preference.rulesetselection.button.copy"));
        button.setSelection(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleSetSelectionDialog.this.importByReference = false;
            }
        });
        return button;
    }

    private void ruleSetChanged() {
        this.updateRuleTable();
        this.checkNonDupes();
        this.warningField.setText("");
        this.adjustOKButton();
    }

    public String getImportedRuleSetName() {
        return this.importedRuleSetName;
    }

    private boolean hasCheckedRules() {
        return this.ruleTable.getCheckedElements().length > 0;
    }

    private RuleSet getSelectedRules() {
        RuleSet rs = new RuleSet();
        rs.setFileName(this.selectedRuleSet.getFileName());
        rs.addExcludePatterns((Collection)this.selectedRuleSet.getExcludePatterns());
        rs.addIncludePatterns((Collection)this.selectedRuleSet.getIncludePatterns());
        Object[] objectArray = this.ruleTable.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object rul = objectArray[n2];
            rs.addRule((Rule)rul);
            ++n2;
        }
        return rs;
    }

    public boolean isImportByReference() {
        return this.importByReference;
    }

    private void adjustOKButton() {
        boolean hasChecks = this.hasCheckedRules();
        this.getButton(0).setEnabled(hasChecks);
    }

    private void ruleChecked() {
        this.updateWarningField();
        this.adjustOKButton();
    }

    private void updateControls() {
        this.updateWarningField();
        this.adjustOKButton();
    }

    private void updateRuleTable() {
        RuleSet candidateRS = this.selectedRuleset();
        if (candidateRS == null) {
            this.ruleTable.getTable().clearAll();
            return;
        }
        this.showRules(candidateRS);
    }

    private boolean updateWarningField() {
        int dupeCount = 0;
        Object[] objectArray = this.ruleTable.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object rule = objectArray[n2];
            if (this.dupeChecker.isDuplicate((Rule)rule)) {
                ++dupeCount;
            }
            ++n2;
        }
        this.warningField.setText(dupeCount == 0 ? "" : "Warning, " + dupeCount + " checked rules already exist in your ruleset");
        return dupeCount > 0;
    }

    private void showRules(RuleSet rs) {
        TableColumn[] columns;
        this.ruleTable.setInput((Object)rs);
        TableColumn[] tableColumnArray = columns = this.ruleTable.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    private RuleSet selectedRuleset() {
        int selectionIndex = this.inputCombo.getSelectionIndex();
        if (selectionIndex == -1) {
            this.importedRuleSetName = this.inputCombo.getText();
            if (StringUtil.isNotEmpty((String)this.importedRuleSetName)) {
                try {
                    RuleSetFactory factory = new RuleSetFactory();
                    RuleSets rs = factory.createRuleSets(this.importedRuleSetName);
                    return rs.getAllRuleSets()[0];
                }
                catch (RuleSetNotFoundException rsnfe) {
                    this.warningField.setText(rsnfe.getMessage());
                    return null;
                }
            }
        }
        return this.ruleSets[selectionIndex];
    }

    public RuleSet checkedRules() {
        return this.checkedRules;
    }

    protected void okPressed() {
        this.selectedRuleSet = this.selectedRuleset();
        this.checkedRules = this.getSelectedRules();
        super.okPressed();
    }

    private String getMessage(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

