/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EnumerationEditorFactory
extends AbstractEditorFactory {
    public static final EnumerationEditorFactory instance = new EnumerationEditorFactory();

    private EnumerationEditorFactory() {
    }

    private static EnumeratedProperty<?> enumerationPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (EnumeratedProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (EnumeratedProperty)desc;
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        ((Combo)valueControl).getSelectionIndex();
        return null;
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String optionalDescription, Control[] otherData) {
        return new EnumeratedProperty(name, "Value set " + name, null, null, 0, 0.0f);
    }

    public static int indexOf(Object item, Object[][] items) {
        int index = EnumerationEditorFactory.indexOf(item, items, 0);
        return index < 0 ? EnumerationEditorFactory.indexOf(item, items, 1) : index;
    }

    public static int indexOf(Object item, Object[][] items, int testColumnIndex) {
        int i = 0;
        while (i < items.length) {
            if (items[i][testColumnIndex].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final Combo combo = new Combo(parent, 8);
        final EnumeratedProperty<?> ep = EnumerationEditorFactory.enumerationPropertyFrom(desc);
        Object value = this.valueFor(source, desc);
        combo.setItems(SWTUtil.labelsIn(ep.choices(), 0));
        int selectionIdx = EnumerationEditorFactory.indexOf(value, ep.choices());
        if (selectionIdx >= 0) {
            combo.select(selectionIdx);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIdx = combo.getSelectionIndex();
                Object newValue = ep.choices()[selectionIdx][1];
                if (newValue == EnumerationEditorFactory.this.valueFor(source, desc)) {
                    return;
                }
                source.setProperty((PropertyDescriptor)ep, newValue);
                listener.changed(source, desc, newValue);
                EnumerationEditorFactory.this.adjustRendering(source, desc, (Control)combo);
            }
        });
        return combo;
    }
}

