/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import net.sourceforge.pmd.NumericPropertyDescriptor;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractNumericEditorFactory;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class IntegerEditorFactory
extends AbstractNumericEditorFactory {
    public static final IntegerEditorFactory instance = new IntegerEditorFactory();

    private IntegerEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String description, Control[] otherData) {
        return new IntegerProperty(name, description, Integer.valueOf(this.minimumIn(otherData).intValue()), Integer.valueOf(this.maximumIn(otherData).intValue()), Integer.valueOf(this.defaultIn(otherData).intValue()), 0.0f);
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        int value = ((Spinner)valueControl).getSelection();
        return value;
    }

    private static IntegerProperty intPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (IntegerProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (IntegerProperty)desc;
    }

    public static Spinner newSpinner(Composite parent, NumericPropertyDescriptor<?> desc, Object valueIn) {
        Spinner spinner = IntegerEditorFactory.newSpinnerFor(parent, 0);
        spinner.setMinimum(desc.lowerLimit().intValue());
        spinner.setMaximum(desc.upperLimit().intValue());
        int value = valueIn == null ? spinner.getMinimum() : ((Number)valueIn).intValue();
        spinner.setSelection(value);
        return spinner;
    }

    protected void setValue(PropertySource source, IntegerProperty desc, Integer value) {
        source.setProperty((PropertyDescriptor)desc, (Object)value);
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final IntegerProperty ip = IntegerEditorFactory.intPropertyFrom(desc);
        final Spinner spinner = IntegerEditorFactory.newSpinner(parent, ip, this.valueFor(source, desc));
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Integer newValue = spinner.getSelection();
                if (newValue.equals(IntegerEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)ip))) {
                    return;
                }
                IntegerEditorFactory.this.setValue(source, ip, newValue);
                listener.changed(source, desc, (Object)newValue);
                IntegerEditorFactory.this.adjustRendering(source, desc, (Control)spinner);
            }
        });
        return spinner;
    }
}

