/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.properties;

import name.herlin.command.CommandException;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractProjectCommand;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import org.eclipse.ui.IWorkingSet;

public class UpdateProjectPropertiesCmd
extends AbstractProjectCommand {
    private static final long serialVersionUID = 1L;
    private boolean pmdEnabled;
    private IWorkingSet projectWorkingSet;
    private RuleSet projectRuleSet;
    private boolean ruleSetStoredInProject;
    private String ruleSetFile;
    private boolean needRebuild;
    private boolean ruleSetFileExists;
    private boolean includeDerivedFiles;
    private boolean fullBuildEnabled = true;
    private boolean violationsAsErrors = true;

    public UpdateProjectPropertiesCmd() {
        super("UpdateProjectProperties", "Update a project PMD specific properties.");
        this.setReadOnly(false);
        this.setOutputProperties(true);
        this.setTerminated(false);
    }

    @Override
    public void execute() throws CommandException {
        try {
            try {
                IProjectProperties properties = this.projectProperties();
                properties.setPmdEnabled(this.pmdEnabled);
                properties.setProjectRuleSet(this.projectRuleSet);
                properties.setProjectWorkingSet(this.projectWorkingSet);
                properties.setRuleSetStoredInProject(this.ruleSetStoredInProject);
                properties.setRuleSetFile(this.ruleSetFile);
                properties.setIncludeDerivedFiles(this.includeDerivedFiles);
                properties.setFullBuildEnabled(this.fullBuildEnabled);
                properties.setViolationsAsErrors(this.violationsAsErrors);
                properties.sync();
                this.needRebuild = properties.isNeedRebuild();
                this.ruleSetFileExists = !properties.isRuleSetFileExist();
            }
            catch (PropertiesException e) {
                throw new CommandException(e.getMessage(), e);
            }
        }
        finally {
            this.setTerminated(true);
        }
    }

    public void setPmdEnabled(boolean pmdEnabled) {
        this.pmdEnabled = pmdEnabled;
    }

    public void setProjectRuleSet(RuleSet projectRuleSet) {
        this.projectRuleSet = projectRuleSet;
    }

    public void setProjectWorkingSet(IWorkingSet projectWorkingSet) {
        this.projectWorkingSet = projectWorkingSet;
    }

    public void setRuleSetStoredInProject(boolean ruleSetStoredInProject) {
        this.ruleSetStoredInProject = ruleSetStoredInProject;
    }

    public void setRuleSetFile(String ruleSetFile) {
        this.ruleSetFile = ruleSetFile;
    }

    public void setIncludeDerivedFiles(boolean includeDerivedFiles) {
        this.includeDerivedFiles = includeDerivedFiles;
    }

    public void setFullBuildEnabled(boolean fullBuildEnabled) {
        this.fullBuildEnabled = fullBuildEnabled;
    }

    public void setViolationsAsErrors(boolean violationsAsErrors) {
        this.violationsAsErrors = violationsAsErrors;
    }

    public boolean isNeedRebuild() {
        return this.needRebuild && this.fullBuildEnabled;
    }

    public boolean isRuleSetFileExists() {
        return this.ruleSetFileExists;
    }

    @Override
    public void reset() {
        this.setProject(null);
        this.setPmdEnabled(false);
        this.setProjectRuleSet(null);
        this.setRuleSetStoredInProject(false);
        this.setRuleSetFile(null);
        this.setIncludeDerivedFiles(false);
        this.setFullBuildEnabled(true);
        this.setViolationsAsErrors(true);
        this.setTerminated(false);
    }

    @Override
    public boolean isReadyToExecute() {
        return super.isReadyToExecute() && this.projectRuleSet != null;
    }
}

