/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.dataflow;

import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.TableColumnSorter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DataflowAnomalyTableViewer
extends TableViewer {
    protected Integer[] columnWidths;
    protected int[] columnSortOrder = new int[]{1, 1, 1};
    protected int currentSortedColumn;

    public DataflowAnomalyTableViewer(Composite parent, int style) {
        super(parent, style | 0x100 | 0x200 | 4 | 0x10000);
        this.setUseHashlookup(true);
        Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumns(table);
        GridData tableData = new GridData(1808);
        table.setLayoutData((Object)tableData);
        GridLayout tableLayout = new GridLayout(1, false);
        tableLayout.verticalSpacing = 0;
        tableLayout.horizontalSpacing = 0;
        table.setLayout((Layout)tableLayout);
    }

    private void createColumns(Table table) {
        TableColumn typeColumn = new TableColumn(table, 16384);
        typeColumn.setWidth(80);
        typeColumn.setText(this.getString("view.dataflow.table.column_type"));
        typeColumn.setToolTipText(this.getString("view.dataflow.table.column_type.tooltip"));
        TableColumn lineColumn = new TableColumn(table, 131072);
        lineColumn.setWidth(100);
        lineColumn.setText(this.getString("view.dataflow.table.column_line"));
        TableColumn varColumn = new TableColumn(table, 131072);
        varColumn.setWidth(70);
        varColumn.setText(this.getString("view.dataflow.table.column_variable"));
        TableColumn methodColumn = new TableColumn(table, 131072);
        methodColumn.setWidth(100);
        methodColumn.setText(this.getString("view.dataflow.table.column_method"));
        this.createColumnAdapters(table);
        this.setSorter(this.getViewerSorter(1));
    }

    private void createColumnAdapters(Table table) {
        TableColumn[] columns = table.getColumns();
        this.columnWidths = new Integer[columns.length];
        int k = 0;
        while (k < columns.length) {
            this.columnWidths[k] = columns[k].getWidth();
            final int i = k;
            columns[k].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int n = DataflowAnomalyTableViewer.this.currentSortedColumn = i;
                    DataflowAnomalyTableViewer.this.columnSortOrder[n] = DataflowAnomalyTableViewer.this.columnSortOrder[n] * -1;
                    DataflowAnomalyTableViewer.this.setSorter(DataflowAnomalyTableViewer.this.getViewerSorter(DataflowAnomalyTableViewer.this.currentSortedColumn));
                }
            });
            columns[k].addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    DataflowAnomalyTableViewer.this.columnWidths[i] = DataflowAnomalyTableViewer.this.getTable().getColumn(i).getWidth();
                }
            });
            ++k;
        }
    }

    private ViewerSorter getViewerSorter(int columnNr) {
        TableColumn column = this.getTable().getColumn(columnNr);
        final int sortOrder = this.columnSortOrder[columnNr];
        TableColumnSorter sorter = null;
        switch (columnNr) {
            case 0: {
                sorter = new TableColumnSorter(column, sortOrder){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        int result = 0;
                        if (e1 instanceof RuleViolation && e2 instanceof RuleViolation) {
                            String message2;
                            RuleViolation violation1 = (RuleViolation)e1;
                            RuleViolation violation2 = (RuleViolation)e2;
                            String message1 = violation1.getDescription();
                            if (message1.equalsIgnoreCase(message2 = violation2.getDescription())) {
                                int m1_l1 = violation1.getBeginLine();
                                int m1_l2 = violation2.getBeginLine();
                                int m2_l1 = violation1.getEndLine();
                                int m2_l2 = violation2.getEndLine();
                                Integer line1 = m1_l1 < m1_l2 ? m1_l1 : m1_l2;
                                Integer line2 = m2_l1 < m2_l2 ? m2_l1 : m2_l2;
                                result = line1.compareTo(line2) * sortOrder;
                            } else {
                                result = message1.compareToIgnoreCase(message2) * sortOrder;
                            }
                        }
                        return result;
                    }
                };
                break;
            }
            case 1: {
                sorter = new TableColumnSorter(column, sortOrder){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        int result = 0;
                        if (e1 instanceof RuleViolation && e2 instanceof RuleViolation) {
                            RuleViolation violation1 = (RuleViolation)e1;
                            RuleViolation violation2 = (RuleViolation)e2;
                            int m1_l1 = violation1.getBeginLine();
                            int m1_l2 = violation2.getBeginLine();
                            int m2_l1 = violation1.getEndLine();
                            int m2_l2 = violation2.getEndLine();
                            Integer line1 = m1_l1 < m1_l2 ? m1_l1 : m1_l2;
                            Integer line2 = m2_l1 < m2_l2 ? m2_l1 : m2_l2;
                            result = line1.compareTo(line2) * sortOrder;
                        }
                        return result;
                    }
                };
                break;
            }
            case 2: {
                sorter = new TableColumnSorter(column, sortOrder){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        int result = 0;
                        if (e1 instanceof RuleViolation && e2 instanceof RuleViolation) {
                            RuleViolation violation1 = (RuleViolation)e1;
                            RuleViolation violation2 = (RuleViolation)e2;
                            String var1 = violation1.getVariableName();
                            String var2 = violation2.getVariableName();
                            result = var1.compareToIgnoreCase(var2) * sortOrder;
                        }
                        return result;
                    }
                };
            }
        }
        return sorter;
    }

    public void setVisible(boolean visible) {
        this.getTable().setVisible(visible);
        ((GridData)this.getTable().getLayoutData()).exclude = !visible;
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

