/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.dataflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.VariableAccess;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class DataflowGraph
extends Composite {
    private List<NodeCanvas> nodes;
    private List<PathCanvas> paths;
    protected int nodeRadius = 12;
    protected int lineLength = 25;
    protected int rowHeight = 2 * this.nodeRadius + this.lineLength;
    protected Color bgColor;
    protected Color nodeColor;
    protected Color textColor;
    protected boolean marked;
    protected Color markColor;
    protected Color markColor2;
    protected Color markColor3;

    public DataflowGraph(Composite parent, Node node, int radius, int length, int height) {
        super(parent, 0);
        if (node == null) {
            return;
        }
        this.nodeRadius = radius;
        this.lineLength = length;
        this.rowHeight = height;
        this.nodes = new ArrayList<NodeCanvas>();
        this.paths = new ArrayList<PathCanvas>();
        Display display = parent.getDisplay();
        this.bgColor = display.getSystemColor(1);
        this.nodeColor = display.getSystemColor(15);
        this.textColor = display.getSystemColor(2);
        this.markColor = new Color(null, 192, 0, 0);
        this.markColor2 = new Color(null, 128, 0, 128);
        this.markColor3 = new Color(null, 0, 0, 96);
        this.setSize(parent.getSize());
        this.setBackground(this.bgColor);
        this.createDataflowGraph(node);
    }

    public void addMouseListener(final MouseListener listener) {
        if (this.nodes != null) {
            Iterator<NodeCanvas> nodeIterator = this.nodes.iterator();
            int i = 0;
            while (nodeIterator.hasNext()) {
                final int row = i++;
                NodeCanvas node = nodeIterator.next();
                node.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        e.y += row * 49;
                        listener.mouseDown(e);
                    }
                });
            }
        }
        super.addMouseListener(listener);
    }

    public void setGraphData(int radius, int length) {
        this.nodeRadius = radius;
        this.lineLength = length;
        this.redraw();
    }

    private void createDataflowGraph(Node node) {
        List flow = node.getDataFlowNode().getFlow();
        int i = 0;
        while (i < flow.size()) {
            DataFlowNode inode = (DataFlowNode)flow.get(i);
            Point location = new Point((this.getSize().x - 2 * this.nodeRadius) / 2, i * this.rowHeight + this.lineLength / 2);
            NodeCanvas nod = new NodeCanvas(this, inode, location, this.nodeRadius);
            this.nodes.add(nod);
            List children = inode.getChildren();
            for (DataFlowNode dfNode : children) {
                int x = (this.getSize().x - 2 * this.nodeRadius) / 2;
                int y1 = inode.getIndex() * this.rowHeight + this.lineLength / 2;
                int y2 = dfNode.getIndex() * this.rowHeight + this.lineLength / 2;
                PathCanvas path = new PathCanvas(this, inode.getIndex(), dfNode.getIndex(), x, y1, y2, this.nodeRadius);
                this.paths.add(path);
            }
            ++i;
        }
    }

    private NodeCanvas getNode(int index) {
        if (this.nodes == null) {
            return null;
        }
        for (NodeCanvas node : this.nodes) {
            if (node.getIndex() != index) continue;
            return node;
        }
        return null;
    }

    private PathCanvas getPath(int index1, int index2) {
        if (this.paths == null) {
            return null;
        }
        for (PathCanvas path : this.paths) {
            if (path.getIndex1() != index1 || path.getIndex2() != index2) continue;
            return path;
        }
        return null;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void demark() {
        for (NodeCanvas node : this.nodes) {
            node.mark(false, null);
        }
        for (PathCanvas path : this.paths) {
            path.mark(false, null);
        }
        this.redraw();
        this.marked = false;
    }

    public void markNode(int index) {
        NodeCanvas node = this.getNode(index);
        node.mark(true, this.markColor3);
    }

    public void markPath(int line1, int line2, String varName) {
        if (this.nodes == null || this.paths == null) {
            return;
        }
        if (line1 > line2) {
            int temp = line1;
            line1 = line2;
            line2 = temp;
        }
        ArrayList<DataFlowNode> startNodes = new ArrayList<DataFlowNode>();
        DataFlowNode endNode = null;
        for (NodeCanvas node : this.nodes) {
            if (!node.containsVariable(varName)) {
                node.mark(false, null);
                continue;
            }
            if (node.getLine() == line1) {
                node.mark(true, this.markColor);
                startNodes.add(node.getINode());
                continue;
            }
            if (node.getLine() == line2) {
                node.mark(true, this.markColor);
                endNode = node.getINode();
                continue;
            }
            node.mark(false, null);
        }
        for (PathCanvas deMarkedPath : this.paths) {
            deMarkedPath.mark(false, null);
        }
        ArrayList<PathCanvas> pathsToMark = new ArrayList<PathCanvas>();
        for (DataFlowNode start : startNodes) {
            List<PathCanvas> pathList = this.findPath(start, endNode, new ArrayList<DataFlowNode>());
            if (pathList == null) continue;
            for (PathCanvas currentPath : pathList) {
                if (pathsToMark.contains(currentPath)) continue;
                pathsToMark.add(currentPath);
            }
        }
        int m = 0;
        while (m < pathsToMark.size()) {
            NodeCanvas markedNode;
            PathCanvas markedPath = (PathCanvas)pathsToMark.get(m);
            markedPath.mark(true, this.markColor);
            if (m < pathsToMark.size() - 1 && !(markedNode = this.getNode(markedPath.getIndex2())).isMarked()) {
                markedNode.mark(true, this.markColor2);
            }
            ++m;
        }
        this.redraw();
        this.marked = true;
    }

    protected List<PathCanvas> findPath(DataFlowNode start, DataFlowNode end, List<DataFlowNode> visited) {
        if (start.getChildren().contains(end)) {
            ArrayList<PathCanvas> found = new ArrayList<PathCanvas>();
            PathCanvas path = this.getPath(start.getIndex(), end.getIndex());
            if (path != null) {
                found.add(path);
                return found;
            }
        } else {
            for (DataFlowNode node : start.getChildren()) {
                if (visited.contains(node)) continue;
                visited.add(node);
                List<PathCanvas> isFound = this.findPath(node, end, visited);
                if (isFound == null) continue;
                PathCanvas path2 = isFound.get(0);
                PathCanvas path1 = this.getPath(start.getIndex(), path2.getIndex1());
                if (path1 == null) continue;
                isFound.add(0, path1);
                return isFound;
            }
        }
        return null;
    }

    private class NodeCanvas
    extends Canvas
    implements PaintListener {
        private DataFlowNode node;
        private int radius;
        private Color bgColor;
        private Color nodeColor;
        private Color textColor;
        protected boolean marked;
        protected Color markColor;

        public NodeCanvas(Composite parent, DataFlowNode inode, Point coordinates, int nodeRadius) {
            super(parent, 0);
            this.node = inode;
            this.radius = nodeRadius;
            Display display = parent.getDisplay();
            this.bgColor = display.getSystemColor(1);
            this.nodeColor = display.getSystemColor(15);
            this.textColor = display.getSystemColor(1);
            this.markColor = display.getSystemColor(3);
            this.setLocation(coordinates);
            this.setSize(2 * this.radius + 1, 2 * this.radius + 1);
            this.setBackground(this.bgColor);
            this.addPaintListener(this);
        }

        public int getLine() {
            return this.node.getLine();
        }

        public int getIndex() {
            return this.node.getIndex();
        }

        public boolean containsVariable(String varName) {
            List vars = this.node.getVariableAccess();
            if (vars == null) {
                return false;
            }
            for (VariableAccess va : vars) {
                if (!va.getVariableName().equalsIgnoreCase(varName)) continue;
                return true;
            }
            return false;
        }

        public DataFlowNode getINode() {
            return this.node;
        }

        public boolean isMarked() {
            return this.marked;
        }

        public void paintControl(PaintEvent e) {
            e.gc.setBackground(this.marked ? this.markColor : this.nodeColor);
            e.gc.fillArc(0, 0, 2 * this.radius, 2 * this.radius, 0, 360);
            e.gc.drawArc(0, 0, 2 * this.radius, 2 * this.radius, 0, 360);
            String indexString = String.valueOf(this.node.getIndex());
            int xPos = this.radius - 2 - 4 * (indexString.length() / 2);
            int yPos = this.radius / 2;
            e.gc.setForeground(this.textColor);
            e.gc.drawString(indexString, xPos - 1, yPos - 1);
        }

        public void mark(boolean isMarked, Color color) {
            this.marked = isMarked;
            this.markColor = color;
            this.redraw();
        }
    }

    private class PathCanvas
    implements PaintListener {
        private int index1;
        private int index2;
        private int radius;
        private Rectangle bounds;
        private Color lineColor;
        private int arrowWidth;
        private int arrowHeight;
        protected boolean marked;
        protected Color markColor;

        public PathCanvas(Composite parent, int nodeIndex1, int nodeIndex2, int x, int y1, int y2, int nodeRadius) {
            this.index1 = nodeIndex1;
            this.index2 = nodeIndex2;
            this.radius = nodeRadius;
            this.arrowWidth = 4;
            this.arrowHeight = 7;
            Display disp = parent.getDisplay();
            this.lineColor = disp.getSystemColor(2);
            this.markColor = new Color(null, 192, 0, 0);
            this.bounds = this.calculateBounds(x, y1, y2);
            parent.addPaintListener((PaintListener)this);
        }

        public int getIndex1() {
            return this.index1;
        }

        public int getIndex2() {
            return this.index2;
        }

        private Rectangle calculateBounds(int x, int y1, int y2) {
            int newX1 = 0;
            int newX2 = 0;
            int newY1 = 0;
            int newY2 = 0;
            if (this.index1 < this.index2) {
                if (this.index2 - this.index1 == 1) {
                    newX1 = x + this.radius - this.arrowWidth;
                    newX2 = x + this.radius + this.arrowWidth;
                    newY1 = y1 + 2 * this.radius;
                    newY2 = y2;
                } else if (this.index2 - this.index1 > 1) {
                    newY1 = y1 + this.radius - 1;
                    newY2 = y2 + this.radius;
                    int n = (this.index2 - this.index1) * 3 + 10;
                    n = (int)((double)n + Math.random() * 5.0);
                    newX1 = x - n;
                    newX2 = x;
                }
            } else if (this.index1 - this.index2 == 1) {
                newX1 = x + this.radius - this.arrowWidth;
                newX2 = x + this.radius + this.arrowWidth;
                newY1 = y2 + 2 * this.radius;
                newY2 = y1;
            } else if (this.index1 - this.index2 > 1) {
                newY1 = y2 + this.radius - 1;
                newY2 = y1 + this.radius;
                int n = (this.index1 - this.index2) * 3 + 10;
                n = (int)((double)n + Math.random() * 5.0);
                newX1 = x + 2 * this.radius;
                newX2 = x + 2 * this.radius + n;
            }
            return new Rectangle(newX1, newY1, newX2, newY2);
        }

        public void paintControl(PaintEvent e) {
            if (this.marked) {
                e.gc.setForeground(this.markColor);
                e.gc.setBackground(this.markColor);
            } else {
                e.gc.setForeground(this.lineColor);
                e.gc.setBackground(this.lineColor);
            }
            int width = this.bounds.width - this.bounds.x;
            if (this.index1 < this.index2) {
                if (this.index2 - this.index1 == 1) {
                    e.gc.drawLine(this.bounds.x + width / 2, this.bounds.y, this.bounds.x + width / 2, this.bounds.height);
                    e.gc.fillPolygon(new int[]{this.bounds.x, this.bounds.height - this.arrowHeight, this.bounds.width, this.bounds.height - this.arrowHeight, this.bounds.x + width / 2, this.bounds.height});
                } else if (this.index2 - this.index1 > 1) {
                    e.gc.drawPolyline(new int[]{this.bounds.x + width, this.bounds.y, this.bounds.x, this.bounds.y + width, this.bounds.x, this.bounds.height - width, this.bounds.width, this.bounds.height});
                    e.gc.fillPolygon(new int[]{this.bounds.width, this.bounds.height, this.bounds.width - this.arrowHeight - this.arrowWidth / 2 + 1, this.bounds.height - this.arrowWidth, this.bounds.width - this.arrowWidth, this.bounds.height - this.arrowHeight - this.arrowWidth / 2});
                }
            } else if (this.index1 - this.index2 == 1) {
                e.gc.drawLine(this.bounds.x + width / 2, this.bounds.y, this.bounds.x + width / 2, this.bounds.height);
                e.gc.fillPolygon(new int[]{this.bounds.x + this.arrowWidth, this.bounds.y, this.bounds.x, this.bounds.y + this.arrowHeight, this.bounds.x + 2 * this.arrowWidth, this.bounds.y + this.arrowHeight});
            } else if (this.index1 - this.index2 > 1) {
                e.gc.drawPolyline(new int[]{this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.y + width, this.bounds.x + width, this.bounds.height - width, this.bounds.x, this.bounds.height});
                e.gc.fillPolygon(new int[]{this.bounds.x, this.bounds.y, this.bounds.x + this.arrowWidth, this.bounds.y + this.arrowHeight + this.arrowWidth / 2, this.bounds.x + this.arrowHeight + this.arrowWidth / 2, this.bounds.y + this.arrowWidth});
            }
        }

        public void mark(boolean isMarked, Color color) {
            this.marked = isMarked;
            this.markColor = color;
        }
    }
}

