/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.completions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.ColorManager;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.HoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesInformationControlCreator;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertyHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.completions.ProposalApplier;
import org.springframework.ide.eclipse.boot.properties.editor.completions.TypeNavigationHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.boot.util.StringUtil;

public class PropertyCompletionFactory {
    public static final ICompletionProposalSorter SORTER = new ICompletionProposalSorter(){

        public int compare(ICompletionProposal p1, ICompletionProposal p2) {
            if (p1 instanceof ScoreableProposal && p2 instanceof ScoreableProposal) {
                double s2;
                double s1 = ((ScoreableProposal)p1).getScore();
                if (s1 == (s2 = ((ScoreableProposal)p2).getScore())) {
                    String name1 = ((ScoreableProposal)p1).getDisplayString();
                    String name2 = ((ScoreableProposal)p2).getDisplayString();
                    return name1.compareTo(name2);
                }
                return Double.compare(s2, s1);
            }
            return 0;
        }
    };
    private DocumentContextFinder documentContextFinder;
    private static final StyledString.Styler UNDERLINE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.underline = true;
        }
    };
    private static final StyledString.Styler GREY_UNDERLINE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = ColorManager.getInstance().getColor(ColorManager.GREY);
            textStyle.underline = true;
        }
    };
    private static final StyledString.Styler GREY = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = ColorManager.getInstance().getColor(ColorManager.GREY);
        }
    };
    private static final StyledString.Styler NULL_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
        }
    };

    public ScoreableProposal property(IDocument doc, ProposalApplier applier, FuzzyMap.Match<PropertyInfo> prop, TypeUtil typeUtil) {
        return new PropertyProposal(doc, applier, prop, typeUtil);
    }

    public ScoreableProposal valueProposal(String value, Type type, int order, ProposalApplier applier) {
        return this.valueProposal(value, type, -(1.0 + (double)order), applier);
    }

    public ScoreableProposal valueProposal(String value, Type type, double score, ProposalApplier applier) {
        return this.simpleProposal(value, score, applier);
    }

    public ScoreableProposal beanProperty(IDocument doc, final String contextProperty, final Type contextType, final String pattern, final TypedProperty p, final double score, ProposalApplier applier, TypeUtil typeUtil) {
        return new AbstractPropertyProposal(this, doc, applier, typeUtil){
            private HoverInfo hoverInfo;

            @Override
            public HoverInfo getAdditionalProposalInfo(IProgressMonitor monitor) {
                if (this.hoverInfo == null) {
                    this.hoverInfo = new TypeNavigationHoverInfo(String.valueOf(contextProperty) + "." + p.getName(), p.getName(), contextType, p.getType(), this.typeUtil);
                }
                return this.hoverInfo;
            }

            @Override
            protected String getBaseDisplayString() {
                return p.getName();
            }

            @Override
            protected String getHighlightPattern() {
                return pattern;
            }

            @Override
            protected Type getType() {
                return p.getType();
            }

            @Override
            public double getBaseScore() {
                return score;
            }
        };
    }

    public ScoreableProposal simpleProposal(String name, int sortingOrder, ProposalApplier applier) {
        return this.simpleProposal(name, -(1.0 + (double)sortingOrder), applier);
    }

    public ScoreableProposal simpleProposal(String name, double score, ProposalApplier applier) {
        return new SimpleProposal(name, score, applier);
    }

    public PropertyCompletionFactory(DocumentContextFinder documentContextFinder) {
        this.documentContextFinder = documentContextFinder;
    }

    private abstract class AbstractPropertyProposal
    extends ScoreableProposal
    implements ICompletionProposalExtension3,
    ICompletionProposalExtension4,
    ICompletionProposalExtension5,
    ICompletionProposalExtension6 {
        protected final IDocument fDoc;
        private final ProposalApplier proposalApplier;
        protected final TypeUtil typeUtil;

        public AbstractPropertyProposal(IDocument doc, ProposalApplier applier, TypeUtil typeUtil) {
            this.proposalApplier = applier;
            this.fDoc = doc;
            this.typeUtil = typeUtil;
        }

        public Point getSelection(IDocument document) {
            try {
                return this.proposalApplier.getSelection(document);
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
                return null;
            }
        }

        public String getAdditionalProposalInfo() {
            HoverInfo hoverInfo = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
            if (hoverInfo != null) {
                return hoverInfo.getHtml();
            }
            return null;
        }

        public abstract HoverInfo getAdditionalProposalInfo(IProgressMonitor var1);

        public String getDisplayString() {
            StyledString styledText = this.getStyledDisplayString();
            return styledText.getString();
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public StyledString getStyledDisplayString() {
            StyledString result = new StyledString();
            this.highlightPattern(this.getHighlightPattern(), this.getBaseDisplayString(), result);
            Type type = this.getType();
            if (type != null) {
                String typeStr = this.typeUtil.niceTypeName(type);
                result.append(" : " + typeStr, StyledString.DECORATIONS_STYLER);
            }
            return result;
        }

        protected abstract Type getType();

        protected abstract String getHighlightPattern();

        protected abstract String getBaseDisplayString();

        private void highlightPattern(String pattern, String data, StyledString result) {
            StyledString.Styler plainStyle;
            StyledString.Styler highlightStyle = this.isDeemphasized() ? GREY_UNDERLINE : UNDERLINE;
            StyledString.Styler styler = plainStyle = this.isDeemphasized() ? GREY : NULL_STYLER;
            if (StringUtil.hasText((String)pattern)) {
                int dataPos = 0;
                int dataLen = data.length();
                int patternPos = 0;
                int patternLen = pattern.length();
                while (dataPos < dataLen && patternPos < patternLen) {
                    char pChar;
                    int highlightPos;
                    if (dataPos < (highlightPos = data.indexOf(pChar = pattern.charAt(patternPos++), dataPos))) {
                        result.append(data.substring(dataPos, highlightPos), plainStyle);
                    }
                    result.append(data.charAt(highlightPos), highlightStyle);
                    dataPos = highlightPos + 1;
                }
                if (dataPos < dataLen) {
                    result.append(data.substring(dataPos), plainStyle);
                }
            } else {
                result.append(data, plainStyle);
            }
        }

        public String toString() {
            return this.getBaseDisplayString();
        }

        public void apply(IDocument document) {
            try {
                this.proposalApplier.apply(document);
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
        }

        public IInformationControlCreator getInformationControlCreator() {
            return new SpringPropertiesInformationControlCreator("F2 for focus");
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return null;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return completionOffset;
        }
    }

    private class PropertyProposal
    extends AbstractPropertyProposal {
        private FuzzyMap.Match<PropertyInfo> match;
        private Type type;

        public PropertyProposal(IDocument doc, ProposalApplier applier, FuzzyMap.Match<PropertyInfo> match, TypeUtil typeUtil) {
            super(doc, applier, typeUtil);
            this.match = match;
        }

        @Override
        public HoverInfo getAdditionalProposalInfo(IProgressMonitor monitor) {
            return new SpringPropertyHoverInfo(PropertyCompletionFactory.this.documentContextFinder.getJavaProject(this.fDoc), (PropertyInfo)this.match.data);
        }

        @Override
        protected String getBaseDisplayString() {
            return ((PropertyInfo)this.match.data).getId();
        }

        @Override
        public double getBaseScore() {
            return this.match.score;
        }

        @Override
        protected Type getType() {
            if (this.type == null) {
                this.type = TypeParser.parse(((PropertyInfo)this.match.data).getType());
            }
            return this.type;
        }

        @Override
        protected String getHighlightPattern() {
            return this.match.getPattern();
        }
    }

    public static abstract class ScoreableProposal
    implements ICompletionProposal,
    ICompletionProposalExtension4 {
        private static final double DEEMP_VALUE = 100000.0;
        private double deemphasizedBy = 0.0;

        public abstract double getBaseScore();

        public final double getScore() {
            return this.getBaseScore() - this.deemphasizedBy;
        }

        public ScoreableProposal deemphasize() {
            this.deemphasizedBy += 100000.0;
            return this;
        }

        public boolean isDeemphasized() {
            return this.deemphasizedBy > 0.0;
        }

        public boolean isAutoInsertable() {
            return !this.isDeemphasized();
        }
    }

    private static class SimpleProposal
    extends ScoreableProposal {
        private String value;
        private ProposalApplier applier;
        private double score;

        public SimpleProposal(String value, double score, ProposalApplier applier) {
            this.score = score;
            this.value = value;
            this.applier = applier;
        }

        public void apply(IDocument doc) {
            try {
                this.applier.apply(doc);
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
        }

        public Point getSelection(IDocument doc) {
            try {
                return this.applier.getSelection(doc);
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
                return null;
            }
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return this.value;
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        @Override
        public double getBaseScore() {
            return this.score;
        }
    }
}

