/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.maven;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.springframework.ide.eclipse.boot.properties.editor.util.AptUtils;
import org.springframework.ide.eclipse.maven.AbstractSpringProjectConfigurator;

public class EnableJdtAptM2EProjectConfigurator
extends AbstractSpringProjectConfigurator {
    protected void doConfigure(MavenProject mavenProject, IProject project, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        if (this.isPreferenceEnabled(mavenProject) && this.shouldConfigureApt(mavenProject, project)) {
            AptUtils.configureApt(JavaCore.create((IProject)project));
        }
    }

    private boolean isPreferenceEnabled(MavenProject mavenProject) {
        return Platform.getPreferencesService().getBoolean("org.springframework.ide.eclipse.boot.properties.editor", "org.springframework.ide.eclipse.apt.autoconfigure.m2e", true, null);
    }

    protected boolean shouldConfigureApt(MavenProject mavenProject, IProject project) {
        IJavaProject jp = JavaCore.create((IProject)project);
        return AptUtils.isAptEnabled(jp) || this.shouldEnableApt(mavenProject);
    }

    protected boolean shouldEnableApt(MavenProject mp) {
        for (Artifact a : mp.getArtifacts()) {
            if (!"org.springframework.boot".equals(a.getGroupId()) || !"spring-boot-configuration-processor".equals(a.getArtifactId())) continue;
            return true;
        }
        return false;
    }
}

