/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.batch.ui.namespaces;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.IReferenceableElementsLocator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchReferenceableElementsLocator
implements IReferenceableElementsLocator {
    public Map<String, Set<Node>> getReferenceableElements(Document document, IFile file) {
        return this.getReferenceableElementsHelper(document.getDocumentElement());
    }

    private Map<String, Set<Node>> getReferenceableElementsHelper(Node parent) {
        HashMap<String, Set<Node>> nodes = new HashMap<String, Set<Node>>();
        NodeList childNodes = parent.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (BeansEditorUtils.hasAttribute((Node)node, (String)"id")) {
                String id = BeansEditorUtils.getAttribute((Node)node, (String)"id");
                HashSet<Node> matchedNodes = (HashSet<Node>)nodes.get(id);
                if (matchedNodes == null) {
                    matchedNodes = new HashSet<Node>();
                    nodes.put(id, matchedNodes);
                }
                matchedNodes.add(node);
            }
            if (node.hasChildNodes()) {
                Map<String, Set<Node>> tempNodes = this.getReferenceableElementsHelper(node);
                for (String id : tempNodes.keySet()) {
                    Set matchedNodes = (Set)nodes.get(id);
                    if (matchedNodes == null) {
                        nodes.put(id, tempNodes.get(id));
                        continue;
                    }
                    matchedNodes.addAll((Collection)tempNodes.get(id));
                }
            }
            ++i;
        }
        return nodes;
    }
}

