/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.configtypes;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.eclipsecs.core.config.CheckConfiguration;
import net.sf.eclipsecs.core.config.CheckConfigurationFactory;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ConfigurationWriter;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ExternalFileConfigurationType;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.config.configtypes.InternalConfigurationType;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationPropertiesDialog;
import net.sf.eclipsecs.ui.config.configtypes.ICheckConfigurationEditor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InternalConfigurationEditor
implements ICheckConfigurationEditor {
    private CheckConfigurationPropertiesDialog mDialog;
    private CheckConfigurationWorkingCopy mWorkingCopy;
    private Text mConfigName;
    private Text mLocation;
    private Text mDescription;
    private Button mBtnImport;

    @Override
    public void initialize(CheckConfigurationWorkingCopy checkConfiguration, CheckConfigurationPropertiesDialog dialog) {
        this.mWorkingCopy = checkConfiguration;
        this.mDialog = dialog;
    }

    @Override
    public Control createEditorControl(Composite parent, Shell shell) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        contents.setLayout((Layout)layout);
        Label lblConfigName = new Label(contents, 0);
        lblConfigName.setText(Messages.CheckConfigurationPropertiesDialog_lblName);
        GridData gd = new GridData();
        lblConfigName.setLayoutData((Object)gd);
        this.mConfigName = new Text(contents, 18436);
        gd = new GridData(768);
        this.mConfigName.setLayoutData((Object)gd);
        Label lblConfigLocation = new Label(contents, 0);
        lblConfigLocation.setText(Messages.CheckConfigurationPropertiesDialog_lblLocation);
        gd = new GridData();
        gd.verticalAlignment = 2;
        lblConfigLocation.setLayoutData((Object)gd);
        this.mLocation = new Text(contents, 18436);
        this.mLocation.setEditable(false);
        gd = new GridData(768);
        this.mLocation.setLayoutData((Object)gd);
        Label lblDescription = new Label(contents, 0);
        lblDescription.setText(Messages.CheckConfigurationPropertiesDialog_lblDescription);
        gd = new GridData();
        gd.horizontalSpan = 2;
        lblDescription.setLayoutData((Object)gd);
        this.mDescription = new Text(contents, 19010);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        gd.heightHint = 100;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.mDescription.setLayoutData((Object)gd);
        this.mBtnImport = new Button(contents, 8);
        this.mBtnImport.setText(Messages.InternalConfigurationEditor_btnImport);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 3;
        this.mBtnImport.setLayoutData((Object)gd);
        this.mBtnImport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CheckConfigurationWorkingCopy targetConfig = InternalConfigurationEditor.this.getEditedWorkingCopy();
                    FileDialog fileDialog = new FileDialog(InternalConfigurationEditor.this.mConfigName.getShell());
                    fileDialog.setText(Messages.InternalConfigurationEditor_titleImportDialog);
                    fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                    String configFileString = fileDialog.open();
                    if (configFileString != null && new File(configFileString).exists()) {
                        CheckConfiguration tmpSourceConfig = new CheckConfiguration("dummy", configFileString, null, (IConfigurationType)new ExternalFileConfigurationType(), true, null, null);
                        CheckConfigurationFactory.copyConfiguration((ICheckConfiguration)tmpSourceConfig, (ICheckConfiguration)targetConfig);
                    }
                }
                catch (CheckstylePluginException ex) {
                    InternalConfigurationEditor.this.mDialog.setErrorMessage(ex.getLocalizedMessage());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.mWorkingCopy.getName() != null) {
            this.mConfigName.setText(this.mWorkingCopy.getName());
        }
        if (this.mWorkingCopy.getLocation() != null) {
            this.mLocation.setText(this.mWorkingCopy.getLocation());
        }
        if (this.mWorkingCopy.getDescription() != null) {
            this.mDescription.setText(this.mWorkingCopy.getDescription());
        }
        return contents;
    }

    @Override
    public CheckConfigurationWorkingCopy getEditedWorkingCopy() throws CheckstylePluginException {
        this.mWorkingCopy.setName(this.mConfigName.getText());
        if (this.mWorkingCopy.getLocation() == null) {
            String location = "internal_config_" + System.currentTimeMillis() + ".xml";
            try {
                this.mWorkingCopy.setLocation(location);
            }
            catch (CheckstylePluginException e) {
                if (StringUtils.trimToNull((String)location) != null && this.ensureFileExists(location)) {
                    this.mWorkingCopy.setLocation(location);
                }
                throw e;
            }
        }
        this.mWorkingCopy.setDescription(this.mDescription.getText());
        return this.mWorkingCopy;
    }

    private boolean ensureFileExists(String location) throws CheckstylePluginException {
        String resolvedLocation = InternalConfigurationType.resolveLocationInWorkspace((String)location);
        File file = new File(resolvedLocation);
        if (!file.exists()) {
            block7: {
                BufferedOutputStream out = null;
                try {
                    try {
                        if (file.getParentFile() != null) {
                            file.getParentFile().mkdirs();
                        }
                        out = new BufferedOutputStream(new FileOutputStream(file));
                        ConfigurationWriter.writeNewConfiguration((OutputStream)out, (ICheckConfiguration)this.mWorkingCopy);
                    }
                    catch (IOException ioe) {
                        CheckstylePluginException.rethrow((Throwable)ioe);
                        IOUtils.closeQuietly(out);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
            return true;
        }
        return true;
    }
}

