/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.runtime;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.osgi.runtime.OsgiPlugin;

public class OsgiUiImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.osgi.runtime.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.osgi.runtime.".length();
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    public static final String IMG_OBJS_OSGI = "org.springframework.ide.eclipse.osgi.runtime.spring_osgi_obj.gif";
    private static final String OBJECT = "obj16/";
    public static final ImageDescriptor DESC_OBJS_OSGI;

    static {
        try {
            ICON_BASE_URL = new URL(OsgiPlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException malformedURLException) {}
        DESC_OBJS_OSGI = OsgiUiImages.createManaged(OBJECT, IMG_OBJS_OSGI);
    }

    static void initializeImageRegistry(ImageRegistry registry) {
        for (String key : imageDescriptors.keySet()) {
            registry.put(key, imageDescriptors.get(key));
        }
    }

    public static Image getImage(String key) {
        return OsgiPlugin.getDefault().getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        OsgiUiImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        OsgiUiImages.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        action.setImageDescriptor(OsgiUiImages.create("e" + type, relPath));
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)OsgiUiImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)OsgiUiImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            return result;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)OsgiUiImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/').append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

