/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import org.eclipse.core.runtime.Assert;
import org.springframework.ide.eclipse.boot.core.IMavenCoordinates;
import org.springframework.ide.eclipse.boot.core.StarterId;
import org.springsource.ide.eclipse.commons.livexp.ui.Ilabelable;

public class SpringBootStarter
implements Ilabelable {
    public static final String AID_PREFIX = "spring-boot-starter-";
    private String name;
    private IMavenCoordinates dep;

    public SpringBootStarter(IMavenCoordinates dep) {
        Assert.isTrue((boolean)dep.getArtifactId().startsWith(AID_PREFIX));
        this.name = dep.getArtifactId().substring(AID_PREFIX.length());
        this.dep = dep;
    }

    public String getName() {
        return this.name;
    }

    public IMavenCoordinates getDep() {
        return this.dep;
    }

    public static boolean isStarter(IMavenCoordinates dep) {
        String id = dep.getArtifactId();
        return id != null && id.startsWith(AID_PREFIX);
    }

    public String toString() {
        return "SpringBootStarter(" + this.getName() + ", " + this.dep.getVersion() + ")";
    }

    public String getArtifactId() {
        return this.getDep().getArtifactId();
    }

    public String getGroupId() {
        return this.getDep().getGroupId();
    }

    public StarterId getId() {
        return new StarterId(this.getGroupId(), this.getArtifactId());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dep == null ? 0 : this.dep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpringBootStarter other = (SpringBootStarter)obj;
        return !(this.dep == null ? other.dep != null : !this.dep.equals(other.dep));
    }

    public String getLabel() {
        return this.getName();
    }
}

