/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.cli.install;

import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.cli.install.BootInstall;
import org.springsource.ide.eclipse.commons.core.ZipFileUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadableItem;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;

public class ZippedBootInstall
extends BootInstall {
    private DownloadableItem zip;
    private File home;

    public ZippedBootInstall(DownloadManager downloader, String uri, String name) throws Exception {
        super(uri, name);
        this.zip = new DownloadableZipItem(new URL(uri), downloader);
    }

    @Override
    public File getHome() throws Exception {
        if (this.home == null) {
            File unzipped = this.zip.getFile();
            File[] fileArray = unzipped.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                File dir = fileArray[n2];
                if (dir.isDirectory() && (name = dir.getName()).startsWith("spring-")) {
                    this.home = dir;
                }
                ++n2;
            }
        }
        return this.home;
    }

    @Override
    public String getUrl() {
        return this.uriString;
    }

    @Override
    protected boolean mayRequireDownload() {
        if (this.zip != null) {
            return !this.zip.isDownloaded();
        }
        return super.mayRequireDownload();
    }

    @Override
    public void clearCache() {
        if (this.zip != null) {
            this.zip.clearCache();
        }
    }

    public class DownloadableZipItem
    extends DownloadableItem {
        private String fileName;

        public DownloadableZipItem(URL url, DownloadManager downloader) {
            super(url, downloader);
        }

        protected String getFileName() {
            if (this.fileName == null) {
                try {
                    String name = new Path(this.getURL().getPath()).lastSegment();
                    if (name != null && name.endsWith(".zip")) {
                        this.fileName = name;
                    }
                }
                catch (Throwable e) {
                    BootActivator.log(e);
                }
                if (this.fileName == null) {
                    this.fileName = String.valueOf(super.getFileName()) + ".zip";
                }
            }
            return this.fileName;
        }

        private synchronized void unzip(File zipFile, File unzipDir) throws Exception {
            if (unzipDir.exists()) {
                return;
            }
            try {
                ZipFileUtil.unzip((File)zipFile, (File)unzipDir, null);
                return;
            }
            catch (Throwable e) {
                FileUtils.deleteQuietly((File)unzipDir);
                throw ExceptionUtil.exception((Throwable)e);
            }
        }

        public File getFile() throws Exception {
            try {
                final File[] fileBox = new File[1];
                this.downloader.doWithDownload((DownloadableItem)this, new DownloadManager.DownloadRequestor(){

                    public void exec(File zipFile) throws Exception {
                        File unzipDir = DownloadableZipItem.this.getUnzipDir();
                        DownloadableZipItem.this.unzip(zipFile, unzipDir);
                        fileBox[0] = unzipDir;
                    }
                });
                this.downloadStatus = Status.OK_STATUS;
                return fileBox[0];
            }
            catch (UIThreadDownloadDisallowed e) {
                throw e;
            }
            catch (Exception e) {
                this.downloadStatus = this.error(ExceptionUtil.getMessage((Throwable)e));
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCache() {
            DownloadManager downloadManager = this.downloader;
            synchronized (downloadManager) {
                super.clearCache();
                File unzipDir = ZippedBootInstall.this.zip.getUnzipDir();
                FileUtils.deleteQuietly((File)unzipDir);
            }
        }
    }
}

