/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class GeneratorComposition {
    public static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];
    public static final IMarkerResolutionGenerator2 NULL_GENERATOR = new IMarkerResolutionGenerator2(){

        public IMarkerResolution[] getResolutions(IMarker marker) {
            return NO_RESOLUTIONS;
        }

        public boolean hasResolutions(IMarker marker) {
            return false;
        }
    };

    public static IMarkerResolutionGenerator2 compose(IMarkerResolutionGenerator2 a, IMarkerResolutionGenerator2 b) {
        if (a == null || a == NULL_GENERATOR) {
            return b;
        }
        if (b == null || b == NULL_GENERATOR) {
            return a;
        }
        return new CompositeGenerator(GeneratorComposition.uncompose(a), GeneratorComposition.uncompose(b));
    }

    private static IMarkerResolutionGenerator2[] uncompose(IMarkerResolutionGenerator2 g) {
        if (g instanceof CompositeGenerator) {
            return ((CompositeGenerator)g).uncompose();
        }
        return new IMarkerResolutionGenerator2[]{g};
    }

    private static class CompositeGenerator
    implements IMarkerResolutionGenerator2 {
        private IMarkerResolutionGenerator2[] children;

        public CompositeGenerator(IMarkerResolutionGenerator2[] children) {
            this.children = children;
        }

        public CompositeGenerator(IMarkerResolutionGenerator2[] children, IMarkerResolutionGenerator2[] moreChildren) {
            this.children = Arrays.copyOf(children, children.length + moreChildren.length);
            System.arraycopy(moreChildren, 0, this.children, children.length, moreChildren.length);
        }

        public IMarkerResolution[] getResolutions(IMarker marker) {
            ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
            IMarkerResolutionGenerator2[] iMarkerResolutionGenerator2Array = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerResolutionGenerator2 generator = iMarkerResolutionGenerator2Array[n2];
                IMarkerResolution[] additions = generator.getResolutions(marker);
                if (additions != null && additions.length > 0) {
                    resolutions.addAll(Arrays.asList(additions));
                }
                ++n2;
            }
            return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
        }

        public boolean hasResolutions(IMarker marker) {
            IMarkerResolutionGenerator2[] iMarkerResolutionGenerator2Array = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerResolutionGenerator2 generator = iMarkerResolutionGenerator2Array[n2];
                if (generator.hasResolutions(marker)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public IMarkerResolutionGenerator2[] uncompose() {
            return this.children;
        }
    }
}

