/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.cli.IBootInstallFactory;
import org.springframework.ide.eclipse.boot.core.cli.install.IBootInstall;
import org.springframework.ide.eclipse.boot.ui.preferences.InstalledBootInstallBlock;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;

public class BootInstallDialog
extends TitleAreaDialog {
    private Text urlText;
    private Text nameText;
    private Text versionText;
    private String url;
    private String name;
    private final IBootInstall install;
    private final InstalledBootInstallBlock prefPage;
    private IBootInstallFactory installFactory;

    public BootInstallDialog(Shell parentShell, IBootInstall install, InstalledBootInstallBlock parent, IBootInstallFactory installFactory) {
        super(parentShell);
        this.prefPage = parent;
        this.install = install;
        this.name = install.getName();
        this.url = install.getUrl();
        this.installFactory = installFactory;
    }

    public IBootInstall getResult() {
        try {
            return this.installFactory.newInstall(this.url, this.name);
        }
        catch (Exception e) {
            BootActivator.log(e);
            return null;
        }
    }

    private void clearError() {
        this.getButton(0).setEnabled(true);
        this.setErrorMessage(null);
    }

    private void setError(String message) {
        this.getButton(0).setEnabled(false);
        this.setErrorMessage(message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label name = new Label(composite, 64);
        name.setText("Name:");
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        if (this.install.getName() != null) {
            this.nameText.setText(this.install.getName());
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BootInstallDialog.this.name = BootInstallDialog.this.nameText.getText();
                BootInstallDialog.this.validate(true);
            }
        });
        Label version = new Label(composite, 64);
        version.setText("Version:");
        this.versionText = new Text(composite, 2048);
        this.versionText.setLayoutData((Object)new GridData(768));
        this.versionText.setEnabled(false);
        if (this.install.getVersion() != null) {
            this.versionText.setText(this.install.getVersion());
        }
        Label directory = new Label(composite, 64);
        directory.setText("Location:");
        this.urlText = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.urlText.setLayoutData((Object)data);
        this.urlText.setEnabled(false);
        if (this.install.getUrl() != null) {
            this.urlText.setText(this.install.getUrl());
        }
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BootInstallDialog.this.validate(true);
            }
        });
        new Label(composite, 64);
        Composite buttonRow = new Composite(composite, 0);
        buttonRow.setLayoutData((Object)new GridData(128));
        buttonRow.setLayout((Layout)new RowLayout());
        Button browseButton = new Button(buttonRow, 8);
        browseButton.setText("Folder...");
        browseButton.setToolTipText("Browse for a local Spring Boot Installation (unzipped into a folder)");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(BootInstallDialog.this.getShell());
                dialog.setMessage("Select Spring Boot installation directory");
                dialog.setText("Boot installation directory");
                String filePath = dialog.open();
                BootInstallDialog.this.handleBrowseButtonResult(filePath);
            }
        });
        browseButton = new Button(buttonRow, 8);
        browseButton.setText("Zip...");
        browseButton.setToolTipText("Browse for a local zip file containing a Spring Boot Installation");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(BootInstallDialog.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.zip"});
                dialog.setText("Boot Zip File");
                String filePath = dialog.open();
                BootInstallDialog.this.handleBrowseButtonResult(filePath);
            }
        });
        this.setTitle("Configure Boot Installation");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void handleBrowseButtonResult(String filePath) {
        if (this.hasText(filePath)) {
            this.url = new File(filePath).toURI().toString();
            IBootInstall newInstall = this.installFactory.newInstall(this.url, null);
            newInstall.clearCache();
            this.urlText.setText(this.url);
            this.nameText.setText(this.prefPage.generateName(newInstall.getName(), this.install));
        }
    }

    private boolean hasText(String result) {
        return result != null && !"".equals(result.trim());
    }

    protected void validate(boolean validateHome) {
        this.clearError();
        try {
            if (this.urlText.getText() == null || this.urlText.getText().equals("")) {
                this.setError("Select a Boot home directory or zip file");
                return;
            }
            if (validateHome) {
                IBootInstall install = this.installFactory.newInstall(this.urlText.getText(), this.nameText.getText());
                IStatus status = install.validate();
                if (!status.isOK()) {
                    this.setError(status.getMessage());
                }
                this.versionText.setText(install.getVersion());
            }
            if (this.nameText.getText() == null || this.nameText.getText().trim().equals("")) {
                this.setError("A name is required");
            } else if (this.prefPage.isDuplicateName(this.nameText.getText(), this.install)) {
                this.setError("Name is not unique");
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
            this.setError(ExceptionUtil.getMessage((Throwable)e));
        }
    }
}

