/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.validation;

import org.eclipse.jdt.core.IClasspathEntry;

public abstract class ClasspathMatcher {
    private boolean defaultValue;
    private boolean isCached = false;
    private IClasspathEntry[] cachedFor;
    private boolean cachedValue;

    public ClasspathMatcher(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected abstract boolean doMatch(IClasspathEntry[] var1);

    protected boolean isJarNameContaining(IClasspathEntry entry, String nameFragment) {
        if (entry.getEntryKind() == 1) {
            return entry.getPath().toString().contains(nameFragment);
        }
        return false;
    }

    public final boolean match(IClasspathEntry[] classpathMaybe) {
        if (this.isCached && this.cachedFor == classpathMaybe) {
            return this.cachedValue;
        }
        boolean value = classpathMaybe != null ? this.doMatch(classpathMaybe) : this.defaultValue;
        this.cachedFor = classpathMaybe;
        this.isCached = true;
        this.cachedValue = value;
        return this.cachedValue;
    }
}

