/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.boot;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.springframework.ide.eclipse.core.StringUtils;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.FieldArrayModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.HierarchicalMultiSelectionFieldModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.MultiSelectionFieldModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioGroup;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioGroups;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioInfo;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.TypeRadioInfo;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.UrlMaker;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.json.InitializrServiceSpec;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.BuildType;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.CodeSet;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportStrategy;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportUtils;
import org.springsource.ide.eclipse.commons.core.preferences.StsProperties;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadableItem;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.URLConnectionFactory;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.StringFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.validators.NewProjectLocationValidator;
import org.springsource.ide.eclipse.commons.livexp.core.validators.NewProjectNameValidator;
import org.springsource.ide.eclipse.commons.livexp.core.validators.UrlValidator;
import org.springsource.ide.eclipse.commons.livexp.ui.ProjectLocationSection;

public class NewSpringBootWizardModel {
    private static final String JSON_CONTENT_TYPE_HEADER = "application/vnd.initializr.v2.1+json";
    private static final Map<String, BuildType> KNOWN_TYPES = new HashMap<String, BuildType>();
    private static final Map<String, String> KNOWN_STRING_INPUTS;
    private static final Map<String, String> KNOWN_SINGLE_SELECTS;
    private final URLConnectionFactory urlConnectionFactory;
    private final String JSON_URL;
    private final String CONTENT_TYPE;
    private final Map<String, LiveExpression<Boolean>> dependencyEnablement = new HashMap<String, LiveExpression<Boolean>>();
    public final FieldArrayModel<String> stringInputs = new FieldArrayModel(new FieldModel[0]);
    public final HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> dependencies = new HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency>(InitializrServiceSpec.Dependency.class, "dependencies").label("Dependencies:");
    private final FieldModel<String> projectName;
    private final LiveVariable<String> location;
    private final NewProjectLocationValidator locationValidator;
    private boolean allowUIThread = false;
    public final LiveVariable<String> baseUrl;
    public final LiveExpression<ValidationResult> baseUrlValidator;
    public final LiveVariable<String> downloadUrl = new LiveVariable();
    private IWorkingSet[] workingSets = new IWorkingSet[0];
    private RadioGroups radioGroups = new RadioGroups();
    private RadioGroup bootVersion;

    static {
        KNOWN_TYPES.put("gradle-project", BuildType.GRADLE);
        KNOWN_TYPES.put("maven-project", BuildType.MAVEN);
        KNOWN_TYPES.put("gradle.zip", BuildType.GRADLE);
        KNOWN_TYPES.put("starter.zip", BuildType.MAVEN);
        KNOWN_STRING_INPUTS = new LinkedHashMap<String, String>();
        KNOWN_STRING_INPUTS.put("name", "Name");
        KNOWN_STRING_INPUTS.put("groupId", "Group");
        KNOWN_STRING_INPUTS.put("artifactId", "Artifact");
        KNOWN_STRING_INPUTS.put("version", "Version");
        KNOWN_STRING_INPUTS.put("description", "Description");
        KNOWN_STRING_INPUTS.put("packageName", "Package");
        KNOWN_SINGLE_SELECTS = new LinkedHashMap<String, String>();
        KNOWN_SINGLE_SELECTS.put("packaging", "Packaging:");
        KNOWN_SINGLE_SELECTS.put("javaVersion", "Java Version:");
        KNOWN_SINGLE_SELECTS.put("language", "Language:");
        KNOWN_SINGLE_SELECTS.put("bootVersion", "Boot Version:");
    }

    public NewSpringBootWizardModel() throws Exception {
        this(new URLConnectionFactory(), StsProperties.getInstance((IProgressMonitor)new NullProgressMonitor()));
    }

    public NewSpringBootWizardModel(URLConnectionFactory urlConnectionFactory, StsProperties stsProps) throws Exception {
        this(urlConnectionFactory, stsProps.get("spring.initializr.json.url"), JSON_CONTENT_TYPE_HEADER);
    }

    public NewSpringBootWizardModel(URLConnectionFactory urlConnectionFactory, String jsonUrl, String contentType) throws Exception {
        this.urlConnectionFactory = urlConnectionFactory;
        this.JSON_URL = jsonUrl;
        this.CONTENT_TYPE = contentType;
        this.baseUrl = new LiveVariable((Object)"<computed>");
        this.baseUrlValidator = new UrlValidator("Base Url", this.baseUrl);
        this.discoverOptions(this.stringInputs, this.dependencies);
        this.dependencies.sort();
        this.projectName = this.stringInputs.getField("name");
        this.projectName.validator((LiveExpression)new NewProjectNameValidator((LiveExpression)this.projectName.getVariable()));
        this.location = new LiveVariable((Object)ProjectLocationSection.getDefaultProjectLocation((String)((String)this.projectName.getValue())));
        this.locationValidator = new NewProjectLocationValidator("Location", this.location, (LiveExpression)this.projectName.getVariable());
        Assert.isNotNull(this.projectName, (String)("The service at " + this.JSON_URL + " doesn't specify a 'name' text input"));
        UrlMaker computedUrl = new UrlMaker((LiveExpression<String>)this.baseUrl);
        for (FieldModel<String> fieldModel : this.stringInputs) {
            computedUrl.addField(fieldModel);
        }
        computedUrl.addField(this.dependencies);
        for (RadioGroup radioGroup : this.radioGroups.getGroups()) {
            computedUrl.addField(radioGroup);
        }
        computedUrl.addListener((ValueListener)new ValueListener<String>(){

            public void gotValue(LiveExpression<String> exp, String value) {
                NewSpringBootWizardModel.this.downloadUrl.setValue((Object)value);
            }
        });
        this.addBuildTypeValidator();
    }

    private void addBuildTypeValidator() {
        RadioGroup buildTypeGroup = this.getRadioGroups().getGroup("type");
        if (buildTypeGroup != null) {
            buildTypeGroup.validator(new Validator(){

                protected ValidationResult compute() {
                    BuildType bt = NewSpringBootWizardModel.this.getBuildType();
                    if (!bt.getImportStrategy().isSupported()) {
                        return ValidationResult.error((String)bt.getNotInstalledMessage());
                    }
                    return ValidationResult.OK;
                }
            }.dependsOn((LiveExpression)buildTypeGroup.getVariable()));
        }
    }

    public void performFinish(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        mon.beginTask("Importing " + (String)this.baseUrl.getValue(), 4);
        DownloadManager downloader = null;
        try {
            try {
                downloader = new DownloadManager().allowUIThread(this.allowUIThread);
                DownloadableItem zip = new DownloadableItem(this.newURL((String)this.downloadUrl.getValue()), downloader);
                String projectNameValue = (String)this.projectName.getValue();
                CodeSet cs = CodeSet.fromZip(projectNameValue, zip, (IPath)new Path("/"));
                IRunnableWithProgress oper = this.getImportStrategy().createOperation(ImportUtils.importConfig((IPath)new Path((String)this.location.getValue()), projectNameValue, cs));
                oper.run((IProgressMonitor)new SubProgressMonitor(mon, 3));
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectNameValue);
                this.addToWorkingSets(project, (IProgressMonitor)new SubProgressMonitor(mon, 1));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (downloader != null) {
                downloader.dispose();
            }
            mon.done();
        }
    }

    public ImportStrategy getImportStrategy() {
        return this.getBuildType().getImportStrategy();
    }

    public BuildType getBuildType() {
        RadioInfo selected;
        RadioGroup buildTypeRadios = this.getRadioGroups().getGroup("type");
        if (buildTypeRadios != null && (selected = (RadioInfo)buildTypeRadios.getSelection().selection.getValue()) != null) {
            BuildType bt = KNOWN_TYPES.get(selected.getValue());
            if (bt != null) {
                return bt;
            }
            return BuildType.GENERAL;
        }
        return BuildType.MAVEN;
    }

    private void addToWorkingSets(IProject project, IProgressMonitor monitor) {
        monitor.beginTask("Add '" + project.getName() + "' to working sets", 1);
        try {
            if (this.workingSets == null || this.workingSets.length == 0) {
                return;
            }
            IWorkingSetManager wsm = PlatformUI.getWorkbench().getWorkingSetManager();
            wsm.addToWorkingSets((IAdaptable)project, this.workingSets);
        }
        finally {
            monitor.done();
        }
    }

    private void discoverOptions(FieldArrayModel<String> fields, HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> dependencies) throws Exception {
        InitializrServiceSpec serviceSpec = this.parseJsonFrom(new URL(this.JSON_URL));
        Map<String, String> textInputs = serviceSpec.getTextInputs();
        for (Map.Entry<String, String> e : KNOWN_STRING_INPUTS.entrySet()) {
            String name = e.getKey();
            String defaultValue = textInputs.get(name);
            if (defaultValue == null) continue;
            fields.add((FieldModel<String>)new StringFieldModel(name, defaultValue).label(e.getValue()));
        }
        String groupName = "type";
        RadioGroup group = this.radioGroups.ensureGroup(groupName);
        group.label("Type:");
        InitializrServiceSpec.Type[] typeArray = serviceSpec.getTypeOptions(groupName);
        int n = typeArray.length;
        int defaultValue = 0;
        while (defaultValue < n) {
            InitializrServiceSpec.Type type = typeArray[defaultValue];
            if (KNOWN_TYPES.containsKey(type.getId())) {
                TypeRadioInfo radio = new TypeRadioInfo(groupName, type.getId(), type.isDefault(), type.getAction());
                radio.setLabel(type.getName());
                group.add(radio);
            }
            ++defaultValue;
        }
        group.getSelection().selection.addListener((ValueListener)new ValueListener<RadioInfo>(){

            public void gotValue(LiveExpression<RadioInfo> exp, RadioInfo value) {
                try {
                    if (value != null) {
                        URI base = new URI(NewSpringBootWizardModel.this.JSON_URL);
                        URI resolved = base.resolve(((TypeRadioInfo)value).getAction());
                        NewSpringBootWizardModel.this.baseUrl.setValue((Object)resolved.toString());
                    }
                }
                catch (Exception e) {
                    WizardPlugin.log(e);
                }
            }
        });
        for (Map.Entry<String, String> e : KNOWN_SINGLE_SELECTS.entrySet()) {
            String groupName2 = e.getKey();
            RadioGroup group2 = this.radioGroups.ensureGroup(groupName2);
            group2.label(e.getValue());
            this.addOptions(group2, serviceSpec.getSingleSelectOptions(groupName2));
            if (!groupName2.equals("bootVersion")) continue;
            this.bootVersion = group2;
        }
        InitializrServiceSpec.DependencyGroup[] dependencyGroupArray = serviceSpec.getDependencies();
        int n2 = dependencyGroupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            InitializrServiceSpec.DependencyGroup dgroup = dependencyGroupArray[n3];
            String catName = dgroup.getName();
            InitializrServiceSpec.Dependency[] dependencyArray = dgroup.getContent();
            int n4 = dependencyArray.length;
            int n5 = 0;
            while (n5 < n4) {
                InitializrServiceSpec.Dependency dep = dependencyArray[n5];
                dependencies.choice(catName, dep.getName(), dep, dep.getDescription(), this.createEnablementExp(this.bootVersion, dep.getVersionRange()));
                ++n5;
            }
            ++n3;
        }
    }

    private LiveExpression<Boolean> createEnablementExp(final RadioGroup bootVersion, String versionRange) {
        try {
            if (StringUtils.hasText((String)versionRange)) {
                final VersionRange range = new VersionRange(versionRange);
                return new LiveExpression<Boolean>(){
                    {
                        this.dependsOn((LiveExpression)radioGroup.getSelection().selection);
                    }

                    protected Boolean compute() {
                        try {
                            String versionStr = ((RadioInfo)bootVersion.getSelection().selection.getValue()).getValue();
                            if (versionStr != null) {
                                Version version = new Version(versionStr);
                                return range.includes(version);
                            }
                        }
                        catch (Exception e) {
                            WizardPlugin.log(e);
                        }
                        return true;
                    }
                };
            }
        }
        catch (Exception e) {
            WizardPlugin.log(e);
        }
        return LiveExpression.TRUE;
    }

    private void addOptions(RadioGroup group, InitializrServiceSpec.Option[] options) {
        InitializrServiceSpec.Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            InitializrServiceSpec.Option option = optionArray[n2];
            RadioInfo radio = new RadioInfo(group.getName(), option.getId(), option.isDefault());
            radio.setLabel(option.getName());
            group.add(radio);
            ++n2;
        }
    }

    private InitializrServiceSpec parseJsonFrom(URL url) throws Exception {
        InitializrServiceSpec initializrServiceSpec;
        block8: {
            URLConnection conn = null;
            InputStream input = null;
            try {
                conn = this.urlConnectionFactory.createConnection(url);
                conn.addRequestProperty("User-Agent", "STS " + WizardPlugin.getDefault().getBundle().getVersion());
                if (this.CONTENT_TYPE != null) {
                    conn.addRequestProperty("Accept", this.CONTENT_TYPE);
                }
                conn.connect();
                input = conn.getInputStream();
                initializrServiceSpec = InitializrServiceSpec.parseFrom(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return initializrServiceSpec;
    }

    private URL newURL(String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            WizardPlugin.log(e);
            return null;
        }
    }

    public void allowUIThread(boolean allow) {
        this.allowUIThread = allow;
    }

    public LiveExpression<ValidationResult> getLocationValidator() {
        return this.locationValidator;
    }

    public LiveVariable<String> getLocation() {
        return this.location;
    }

    public FieldModel<String> getProjectName() {
        return this.projectName;
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        this.workingSets = workingSets;
    }

    public RadioGroups getRadioGroups() {
        return this.radioGroups;
    }

    public RadioGroup getBootVersion() {
        return this.bootVersion;
    }

    public FieldModel<String> getArtifactId() {
        String fieldName = "artifactId";
        return this.getStringInput(fieldName);
    }

    public FieldModel<String> getStringInput(String fieldName) {
        for (FieldModel<String> fieldModel : this.stringInputs) {
            if (!fieldName.equals(fieldModel.getName())) continue;
            return fieldModel;
        }
        return null;
    }

    public void addDependency(String dependencyId) {
        for (String catName : this.dependencies.getCategories()) {
            MultiSelectionFieldModel<InitializrServiceSpec.Dependency> cat = this.dependencies.getContents(catName);
            InitializrServiceSpec.Dependency[] dependencyArray = cat.getChoices();
            int n = dependencyArray.length;
            int n2 = 0;
            while (n2 < n) {
                InitializrServiceSpec.Dependency dep = dependencyArray[n2];
                if (dependencyId.equals(dep.getId())) {
                    cat.add(dep);
                    return;
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException("No such dependency: " + dependencyId);
    }
}

