/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.template.SimpleProject;
import org.springframework.ide.eclipse.wizard.template.infrastructure.BundleContentLoader;
import org.springframework.ide.eclipse.wizard.template.infrastructure.SimpleProjectFactory;
import org.springframework.ide.eclipse.wizard.template.infrastructure.TemplateProjectData;
import org.springsource.ide.eclipse.commons.content.core.ContentItem;
import org.springsource.ide.eclipse.commons.content.core.ContentLocation;
import org.springsource.ide.eclipse.commons.content.core.ContentManager;
import org.springsource.ide.eclipse.commons.content.core.ContentPlugin;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;
import org.springsource.ide.eclipse.commons.content.core.util.DescriptorReader;
import org.springsource.ide.eclipse.commons.internal.content.core.DescriptorMatcher;

public class SimpleProjectContentManager {
    private final List<ContentLocation> contentLocations = new ArrayList<ContentLocation>();
    private List<ContentItem> projectItems = null;
    private static SimpleProjectContentManager manager;
    public static final String INSTALL_DIRECTORY = "simpleprojects";

    public static SimpleProjectContentManager getManager() {
        if (manager == null) {
            manager = new SimpleProjectContentManager();
            ContentLocation location = WizardPlugin.getDefault().getTemplateContentLocation();
            manager.addContentLocation(location);
        }
        return manager;
    }

    public void addContentLocation(ContentLocation contentLocation) {
        if (contentLocation != null && !this.contentLocations.contains(contentLocation)) {
            this.contentLocations.add(contentLocation);
        }
    }

    public File getInstallDirectory() {
        ContentManager manager = ContentPlugin.getDefault().getManager();
        File file = new File(manager.getDataDirectory(), INSTALL_DIRECTORY);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public List<ContentItem> readFromContentLocations() throws CoreException {
        if (this.projectItems != null && !this.projectItems.isEmpty()) {
            return this.projectItems;
        }
        this.projectItems = new ArrayList<ContentItem>();
        for (ContentLocation location : this.contentLocations) {
            File file = location.getContentLocationFile();
            if (file == null || !file.exists()) continue;
            this.projectItems.addAll(this.read(file));
        }
        return this.projectItems;
    }

    protected List<ContentItem> read(File file) throws CoreException {
        DescriptorMatcher matcher = new DescriptorMatcher(this.getInstallDirectory());
        DescriptorReader reader = new DescriptorReader();
        reader.read(file);
        List descriptors = reader.getDescriptors();
        ArrayList<ContentItem> items = new ArrayList<ContentItem>();
        for (Descriptor descriptor : descriptors) {
            if (!matcher.match(descriptor)) continue;
            ContentItem item = new ContentItem(descriptor.getId());
            item.setLocalDescriptor(descriptor);
            items.add(item);
        }
        return items;
    }

    public List<SimpleProject> getSimpleProjects(IProgressMonitor monitor) throws CoreException {
        File baseDir = this.getInstallDirectory();
        if (baseDir == null || !baseDir.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Unable to unzip Spring simple project zip files, possibly due to write permission error when creating simple project content directory in: " + ContentPlugin.getDefault().getManager().getDataDirectory().toString()));
        }
        List<ContentItem> projectItems = this.readFromContentLocations();
        ArrayList<SimpleProject> projects = new ArrayList<SimpleProject>();
        for (ContentItem item : projectItems) {
            SimpleProject simpleProject;
            if (!SimpleProjectFactory.isSimpleProject(item) || (simpleProject = SimpleProjectFactory.getSimpleProject(item)) == null) continue;
            BundleContentLoader loader = new BundleContentLoader(item, WizardPlugin.getDefault().getBundle(), this);
            loader.load(monitor);
            File projectDir = new File(baseDir, item.getPath());
            TemplateProjectData data = new TemplateProjectData(projectDir);
            data.read();
            simpleProject.setTemplateData(data);
            projects.add(simpleProject);
        }
        return projects;
    }

    public boolean exists(File projectToLookFor) {
        File dir = this.getInstallDirectory();
        File[] children = dir.listFiles();
        if (children == null || children.length <= 0) {
            return false;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File childDirectory = fileArray[n2];
            if (childDirectory.isDirectory() && childDirectory.getName().equals(projectToLookFor.getName()) && new File(childDirectory, "template.xml").exists()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

