/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class OrganizationService
extends GitHubService {
    public OrganizationService() {
    }

    public OrganizationService(GitHubClient client) {
        super(client);
    }

    protected PagedRequest<User> createOrgRequest(String user, int start, int size) {
        PagedRequest<User> request = new PagedRequest<User>(start, size);
        if (user == null) {
            request.setUri("/user/orgs");
        } else {
            StringBuilder uri = new StringBuilder("/users");
            uri.append('/').append(user);
            uri.append("/orgs");
            request.setUri(uri);
        }
        request.setType(new TypeToken<List<User>>(){}.getType());
        return request;
    }

    public List<User> getOrganizations() throws IOException {
        PagedRequest<User> request = this.createOrgRequest(null, 1, 100);
        return this.getAll(request);
    }

    public List<User> getOrganizations(String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        PagedRequest<User> request = this.createOrgRequest(user, 1, 100);
        return this.getAll(request);
    }

    public User getOrganization(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(name);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)User.class));
        return (User)this.client.get(request).getBody();
    }

    public User editOrganization(User organization) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        String name = organization.getLogin();
        if (name == null) {
            throw new IllegalArgumentException("Organization login cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Organization login cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(name);
        return (User)this.client.post(uri.toString(), organization, (Type)((Object)User.class));
    }

    public List<User> getMembers(String organization) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/members");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<User>>(){}.getType());
        return this.getAll(request);
    }

    public List<User> getPublicMembers(String organization) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/public_members");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<User>>(){}.getType());
        return this.getAll(request);
    }

    public boolean isMember(String organization, String user) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/members");
        uri.append('/').append(user);
        return this.check(uri.toString());
    }

    public boolean isPublicMember(String organization, String user) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/public_members");
        uri.append('/').append(user);
        return this.check(uri.toString());
    }

    public void showMembership(String organization, String user) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/public_members");
        uri.append('/').append(user);
        this.client.put(uri.toString());
    }

    public void hideMembership(String organization, String user) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/public_members");
        uri.append('/').append(user);
        this.client.delete(uri.toString());
    }

    public void removeMember(String organization, String user) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/members");
        uri.append('/').append(user);
        this.client.delete(uri.toString());
    }
}

