/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.core;

import com.atlassian.connector.eclipse.internal.bamboo.core.BambooClientManager;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooClient;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public class BambooRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String REPOSITORY_LABEL = "Bamboo (supports 2.2.4 and later)";
    private BambooClientManager clientManager;
    private File repositoryConfigurationCacheFile;

    public BambooRepositoryConnector() {
        BambooCorePlugin.setRepositoryConnector(this);
        if (BambooCorePlugin.getDefault() != null) {
            this.repositoryConfigurationCacheFile = BambooCorePlugin.getDefault().getRepositoryConfigurationCacheFile();
        }
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return false;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return false;
    }

    public boolean canQuery(TaskRepository repository) {
        return false;
    }

    public boolean canSynchronizeTask(TaskRepository taskRepository, ITask task) {
        return false;
    }

    public synchronized BambooClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = new BambooClientManager(this.getRepositoryConfigurationCacheFile());
        }
        return this.clientManager;
    }

    public String getConnectorKind() {
        return "bamboo";
    }

    public String getLabel() {
        return REPOSITORY_LABEL;
    }

    public File getRepositoryConfigurationCacheFile() {
        return this.repositoryConfigurationCacheFile;
    }

    public String getRepositoryUrlFromTaskUrl(String taskFullUrl) {
        return null;
    }

    public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public String getTaskIdFromTaskUrl(String taskFullUrl) {
        return null;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        return null;
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        return false;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector resultCollector, ISynchronizationSession event, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public void updateRepositoryConfiguration(TaskRepository taskRepository, IProgressMonitor monitor) throws CoreException {
        BambooClient client = this.getClientManager().getClient(taskRepository);
        client.updateRepositoryData(monitor, taskRepository);
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
    }

    public synchronized void flush() {
        if (this.clientManager != null) {
            this.clientManager.writeCache();
        }
    }
}

