/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.BeanReferenceContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.ClassContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.PropertyNameContentAssistCalculator;
import org.springframework.ide.eclipse.quickfix.ContentAssistProposalWrapper;
import org.springframework.ide.eclipse.quickfix.QuickFixContentAssistProposalRecorder;

public abstract class AbstractContentAssistConverter {
    private final IDOMNode node;
    private final IFile file;
    private final String attributeName;

    public AbstractContentAssistConverter(IDOMNode node, String attributeName, IFile file) {
        this.node = node;
        this.attributeName = attributeName;
        this.file = file;
    }

    private Set<ContentAssistProposalWrapper> computeNameMatchedProposals(String toBeMatched, boolean exactMatch, String prefix, IContentAssistCalculator calculator) {
        Set<ContentAssistProposalWrapper> proposals = this.computeProposals(prefix, calculator);
        HashSet<ContentAssistProposalWrapper> result = new HashSet<ContentAssistProposalWrapper>();
        for (ContentAssistProposalWrapper proposal : proposals) {
            String name = proposal.getName();
            if (!this.isMatched(toBeMatched, name, exactMatch)) continue;
            result.add(proposal);
        }
        return result;
    }

    private Set<ContentAssistProposalWrapper> computeProposals(String prefix, IContentAssistCalculator calculator) {
        QuickFixContentAssistProposalRecorder recorder = new QuickFixContentAssistProposalRecorder();
        IContentAssistContext context = this.createContext(this.node, this.attributeName, this.file, prefix);
        calculator.computeProposals(context, (IContentAssistProposalRecorder)recorder);
        return recorder.getProposals();
    }

    protected abstract IContentAssistContext createContext(IDOMNode var1, String var2, IFile var3, String var4);

    public Set<ContentAssistProposalWrapper> getClassAttributeProposals(String toBeMatched, boolean exactMatch) {
        return this.computeNameMatchedProposals(toBeMatched, exactMatch, toBeMatched, (IContentAssistCalculator)new ClassContentAssistCalculator());
    }

    public Set<ContentAssistProposalWrapper> getMethodProposals(String toBeMatched, boolean exactMatch, IContentAssistCalculator calculator) {
        return this.computeNameMatchedProposals(toBeMatched, exactMatch, "", calculator);
    }

    public Set<ContentAssistProposalWrapper> getPropertyProposals(String toBeMatched, boolean exactMatch) {
        return this.computeNameMatchedProposals(toBeMatched, exactMatch, "", (IContentAssistCalculator)new PropertyNameContentAssistCalculator());
    }

    public Set<ContentAssistProposalWrapper> getReferenceableBeanDescriptions(String toBeMatched, boolean exactMatch) {
        return this.getMethodProposals(toBeMatched, exactMatch, (IContentAssistCalculator)new BeanReferenceContentAssistCalculator());
    }

    private boolean isMatched(String toBeMatched, String name, boolean exactMatch) {
        if (exactMatch) {
            return name.equals(toBeMatched);
        }
        return NameMatcher.isSimilarName((String)toBeMatched, (String)name);
    }
}

