/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AnnotationCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class AddExceptionHandlerCompletionProposal
extends AnnotationCompletionProposal {
    private final MethodDeclaration methodDecl;
    private final List<String> exceptionNames;

    public AddExceptionHandlerCompletionProposal(MethodDeclaration methodDecl, List<String> exceptionNames, ICompilationUnit cu) {
        super(AddExceptionHandlerCompletionProposal.getDisplayName(exceptionNames), cu, QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.methodDecl = methodDecl;
        this.exceptionNames = exceptionNames;
    }

    private static String getDisplayName(List<String> exceptionNames) {
        StringBuilder result = new StringBuilder();
        result.append("Add @ExceptionHandler");
        if (exceptionNames.size() > 0) {
            result.append("(");
            int i = 0;
            while (i < exceptionNames.size()) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(exceptionNames.get(i));
                ++i;
            }
            result.append(")");
        }
        return result.toString();
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        MarkerAnnotation annotation;
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.methodDecl);
        ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
        String importName = ExceptionHandler.class.getCanonicalName();
        if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), importName)) {
            this.createImportRewrite(astRoot).addImport(importName);
        }
        AST ast = astRewrite.getAST();
        if (this.exceptionNames.isEmpty()) {
            MarkerAnnotation mAnnotation;
            annotation = mAnnotation = ast.newMarkerAnnotation();
        } else {
            TypeLiteral value;
            SingleMemberAnnotation sAnnotation = ast.newSingleMemberAnnotation();
            annotation = sAnnotation;
            if (this.exceptionNames.size() == 1) {
                TypeLiteral typeLiteral;
                value = typeLiteral = this.getTypeLiteral(this.exceptionNames.get(0), ast);
                this.addLinkedPosition(astRewrite.track((ASTNode)typeLiteral.getType()), true, "ExceptionHandler");
            } else {
                ArrayInitializer arrayInitializer = ast.newArrayInitializer();
                List expressions = arrayInitializer.expressions();
                int i = 0;
                while (i < this.exceptionNames.size()) {
                    String exceptionName = this.exceptionNames.get(i);
                    TypeLiteral typeLiteral = this.getTypeLiteral(exceptionName, ast);
                    this.addLinkedPosition(astRewrite.track((ASTNode)typeLiteral.getType()), i == 0, "ExceptionHandler" + i);
                    expressions.add(typeLiteral);
                    ++i;
                }
                value = arrayInitializer;
            }
            sAnnotation.setValue((Expression)value);
        }
        SimpleName name = ast.newSimpleName("ExceptionHandler");
        annotation.setTypeName((Name)name);
        astRewrite.getListRewrite((ASTNode)this.methodDecl, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)annotation, null);
        return astRewrite;
    }

    private TypeLiteral getTypeLiteral(String exceptionName, AST ast) {
        TypeLiteral typeLiteral = ast.newTypeLiteral();
        SimpleName typeName = ast.newSimpleName(exceptionName);
        SimpleType type = ast.newSimpleType((Name)typeName);
        typeLiteral.setType((Type)type);
        return typeLiteral;
    }
}

