/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.NameSuggestionComparator;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.CreateNewMethodQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.RenameToSimilarNameQuickFixProposal;

public class PropertyAttributeQuickAssistProcessor
extends BeanQuickAssistProcessor {
    private final String className;
    private final IJavaProject javaProject;
    private final IProject project;
    private final Type type;

    public PropertyAttributeQuickAssistProcessor(int offset, int length, String className, String propertyName, IProject project, boolean missingEndQuote, Type type) {
        super(offset, length, propertyName, missingEndQuote);
        this.className = className;
        this.project = project;
        this.type = type;
        this.javaProject = JavaCore.create((IProject)project);
    }

    private void addPropertyName(String property, Set<String> properties) {
        if (NameMatcher.isSimilarName((String)property, (String)this.text)) {
            if (property.length() > 1 && Character.isUpperCase(property.charAt(1))) {
                properties.add(property);
            } else {
                properties.add(String.valueOf(property.substring(0, 1).toLowerCase()) + property.substring(1));
            }
        }
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ArrayList<BeanAttributeQuickFixProposal> proposals = new ArrayList<BeanAttributeQuickFixProposal>();
        List<String> similarProperties = this.getSimilarProperties();
        for (String similarProperty : similarProperties) {
            RenameToSimilarNameQuickFixProposal p = new RenameToSimilarNameQuickFixProposal(similarProperty, this.offset, this.length, this.missingEndQuote);
            proposals.add(p);
        }
        CreateNewMethodQuickFixProposal proposal = QuickfixUtils.getNewMethodQuickFixProposal(this.getNewMethodName(), null, this.getMethodParamTypes(), this.javaProject, this.className, this.offset, this.length, this.text, this.missingEndQuote, false, "property");
        if (proposal != null) {
            proposals.add(proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private String[] getMethodParamTypes() {
        switch (this.type) {
            case SETTER: {
                return new String[]{"Object"};
            }
            case GETTER: {
                return new String[0];
            }
        }
        return null;
    }

    private String getNewMethodName() {
        String firstChar = this.text.substring(0, 1);
        switch (this.type) {
            case SETTER: {
                return "set" + firstChar.toUpperCase() + this.text.substring(1);
            }
            case GETTER: {
                return "get" + firstChar.toUpperCase() + this.text.substring(1);
            }
        }
        return null;
    }

    private List<String> getSimilarProperties() {
        HashSet<String> properties = new HashSet<String>();
        IType type = JdtUtils.getJavaType((IProject)this.project, (String)this.className);
        if (type != null) {
            try {
                Set methods = Introspector.findAllWritableProperties((IType)type);
                for (IMethod method : methods) {
                    String methodName = method.getElementName();
                    if (!methodName.startsWith("set")) continue;
                    String propertyName = methodName.replace("set", "");
                    this.addPropertyName(propertyName, properties);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        ArrayList<String> result = new ArrayList<String>(properties);
        Collections.sort(result, new NameSuggestionComparator(this.text));
        return result;
    }

    public static enum Type {
        GETTER,
        SETTER;

    }
}

