/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.refresh.RefreshUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateNewBeanQuickFixProposal
extends BeanAttributeQuickFixProposal {
    private final String beanName;
    private final IDOMNode beanNode;
    private int cursorPosition = -1;

    public CreateNewBeanQuickFixProposal(int offset, int length, boolean missingEndQuote, String beanName, IDOMNode beanNode) {
        super(offset, length, missingEndQuote);
        this.beanName = beanName;
        this.beanNode = beanNode;
    }

    private void addNode(Element newBean, Node nextNode, IFile file, IDOMElement beansNode) {
        if (nextNode == null) {
            beansNode.appendChild((Node)newBean);
        } else {
            beansNode.insertBefore((Node)newBean, nextNode);
        }
        RefreshUtils.refreshCurrentEditor((IResource)file);
    }

    @Override
    public void applyQuickFix(IDocument document) {
        Node parentNode = this.beanNode.getParentNode();
        IDOMElement beansNode = (IDOMElement)this.beanNode.getOwnerDocument().getDocumentElement();
        Object currentNode = this.beanNode;
        while (parentNode != null && !parentNode.equals(beansNode)) {
            currentNode = parentNode;
            parentNode = parentNode.getParentNode();
        }
        Node nextNode = currentNode.getNextSibling();
        Document ownerDocument = beansNode.getOwnerDocument();
        Element newBean = this.createNewBean(ownerDocument);
        Attr classAttribute = this.createClassAttribute(newBean, ownerDocument);
        this.addNode(newBean, nextNode, BeansEditorUtils.getFile((IDocument)document), beansNode);
        try {
            document.replace(this.getOffset(), 0, "");
            ShallowFormatProcessorXML formatter = new ShallowFormatProcessorXML();
            formatter.formatNode((Node)newBean);
            if (parentNode instanceof IDOMElement) {
                int docLength = document.getLength();
                int startOffset = ((IDOMElement)newBean).getStartOffset() - 1;
                int length = ((IDOMElement)newBean).getLength() + 2;
                formatter.formatDocument(document, startOffset >= 0 ? startOffset : 0, length + startOffset <= docLength ? length : docLength - startOffset);
            }
            if (classAttribute instanceof AttrImpl && newBean instanceof IDOMNode) {
                this.cursorPosition = ((IDOMNode)newBean).getStartOffset() + ((AttrImpl)classAttribute).getValueRegion().getTextEnd() - 1;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    private Attr createClassAttribute(Element newBean, Document ownerDocument) {
        Attr classAttribute = ownerDocument.createAttribute("class");
        classAttribute.setValue("");
        newBean.setAttributeNode(classAttribute);
        return classAttribute;
    }

    private Element createNewBean(Document ownerDocument) {
        String localName;
        String tagName = localName = BeansSchemaConstants.ELEM_BEAN;
        String prefix = ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)((IDOMDocument)ownerDocument), (String)BeansSchemaConstants.URI);
        if (prefix != null && prefix.length() > 0) {
            tagName = String.valueOf(prefix) + ":" + localName;
        }
        Element newBean = ownerDocument.createElement(tagName);
        Attr idAttribute = ownerDocument.createAttribute("id");
        idAttribute.setValue(this.beanName);
        newBean.setAttributeNode(idAttribute);
        return newBean;
    }

    public String getDisplayString() {
        return "Create missing bean '" + this.beanName + "'";
    }

    public Image getImage() {
        return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.bean_obj.gif");
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.cursorPosition < 0) {
            return super.getSelection(document);
        }
        return new Point(this.cursorPosition, 0);
    }

    @Override
    public void run(IMarker marker) {
        try {
            IDocument document;
            String beanName = (String)marker.getAttribute("BEAN");
            if (beanName != null && (document = QuickfixUtils.getDocument(marker)) != null) {
                this.applyQuickFix(document);
            }
        }
        catch (CoreException coreException) {}
    }
}

