/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;

public class RenameToSimilarNameQuickFixProposal
extends BeanAttributeQuickFixProposal {
    private final String suggestedName;
    private final String suggestedDescription;

    public RenameToSimilarNameQuickFixProposal(String suggestedName, int offset, int length, boolean missingEndQuote) {
        this(suggestedName, offset, length, missingEndQuote, null);
    }

    public RenameToSimilarNameQuickFixProposal(String suggestedName, int offset, int length, boolean missingEndQuote, String suggestedDescription) {
        super(offset, length, missingEndQuote);
        this.suggestedName = suggestedName;
        this.suggestedDescription = suggestedDescription;
    }

    @Override
    public void applyQuickFix(IDocument document) {
        try {
            document.replace(this.getOffset(), this.getLength(), this.suggestedName);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getDisplayString() {
        String packageName;
        String className;
        if (this.suggestedDescription != null) {
            return "Change to " + this.suggestedDescription;
        }
        int lastDotPos = this.suggestedName.lastIndexOf(".");
        if (lastDotPos < 0) {
            className = this.suggestedName;
            packageName = "";
        } else {
            className = this.suggestedName.substring(lastDotPos + 1);
            packageName = " (" + this.suggestedName.substring(0, lastDotPos) + ")";
        }
        return "Change to " + className + packageName;
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
    }
}

