/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinitionFactory;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class BeanValidator {
    private String namespaceURI;
    private String nodeName;
    private String attributeName;
    private String namespaceURIException;
    protected final String[] BEANS_VALIDATOR_IDS = new String[]{"org.springframework.ide.eclipse.beans.core.beansvalidator"};

    public final boolean accept(Node node) {
        return this.acceptNamespaceURI(node.getNamespaceURI()) && this.acceptNodeName(node.getLocalName());
    }

    public final boolean acceptAttribute(Node node, Attr attr) {
        return this.accept(node) && this.acceptAttributeName(attr.getLocalName());
    }

    private boolean acceptAttributeName(String attributeName) {
        if (this.attributeName == null) {
            return true;
        }
        if (attributeName == null) {
            return false;
        }
        return this.attributeName.equals(attributeName);
    }

    private boolean acceptNamespaceURI(String namespaceURI) {
        if (this.namespaceURI == null) {
            if (this.namespaceURIException != null) {
                return !this.namespaceURIException.equals(namespaceURI);
            }
            return true;
        }
        if (namespaceURI == null) {
            return false;
        }
        if (this.namespaceURI.startsWith("!")) {
            return !this.namespaceURI.substring(1).equals(namespaceURI);
        }
        return this.namespaceURI.equals(namespaceURI);
    }

    private boolean acceptNodeName(String nodeName) {
        if (this.nodeName == null) {
            return true;
        }
        if (nodeName == null) {
            return false;
        }
        return this.nodeName.equals(nodeName);
    }

    public final IDOMNode getParentBeanNode(IDOMNode node) {
        String localName = node.getLocalName();
        if (localName == null) {
            return null;
        }
        if (localName.equals(BeansSchemaConstants.ELEM_BEAN)) {
            return node;
        }
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode instanceof IDOMNode) {
            return this.getParentBeanNode((IDOMNode)parentNode);
        }
        return null;
    }

    protected final ValidationRuleDefinition getValidationRule(IProject project, Class<?> clazz) {
        String[] stringArray = this.BEANS_VALIDATOR_IDS;
        int n = this.BEANS_VALIDATOR_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Set rules = ValidationRuleDefinitionFactory.getEnabledRuleDefinitions((String)id, (IProject)project);
            for (ValidationRuleDefinition rule : rules) {
                if (!rule.getRule().getClass().equals(clazz)) continue;
                return rule;
            }
            ++n2;
        }
        return null;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public void setNamespaceURIException(String namespaceURIException) {
        this.namespaceURIException = namespaceURIException;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public final boolean validateAttributeWithConfig(IBeansConfig config, IResourceModelElement contextElement, AttrImpl attribute, IDOMNode parent, IReporter reporter, boolean reportError, BeansEditorValidator validator) {
        String text = attribute.getValueRegionText();
        if (text == null) {
            return true;
        }
        IFile file = validator.getFile();
        return this.validateAttributeWithConfig(config, contextElement, file, attribute, parent, reporter, reportError, validator, text.replaceAll("\"", ""));
    }

    public boolean validateAttributeWithConfig(IBeansConfig config, IResourceModelElement contextElement, IFile file, AttrImpl attribute, IDOMNode parent, IReporter reporter, boolean reportError, BeansEditorValidator validator, String text) {
        return false;
    }
}

