/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui;

import com.atlassian.connector.eclipse.internal.bamboo.ui.EclipseBambooBuild;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import com.atlassian.theplugin.commons.bamboo.PlanState;
import com.atlassian.theplugin.commons.bamboo.TestDetails;
import java.util.Iterator;
import org.eclipse.mylyn.commons.ui.compatibility.CommonFonts;
import org.eclipse.swt.graphics.Font;

public final class BambooUiUtil {
    public static final String LOG_STR_ERROR = "error";

    private BambooUiUtil() {
    }

    public static String getCommentSnippet(String comment) {
        String[] commentLines = comment.split("[\r\n]");
        return commentLines.length == 0 ? "N/A" : commentLines[0];
    }

    public static String formatTestMethodName(String methodName) {
        int i = methodName.indexOf("test");
        if (i != -1) {
            methodName = methodName.substring(i + 4);
        }
        StringBuilder b = new StringBuilder();
        char[] cArray = methodName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c)) {
                b.append(" ");
            }
            b.append(c);
            ++n2;
        }
        return b.toString();
    }

    public static String getFailedTestsDescription(BuildDetails buildDetails) {
        if (buildDetails == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        Iterator it = buildDetails.getFailedTestDetails().iterator();
        while (it.hasNext()) {
            TestDetails details = (TestDetails)it.next();
            String testClassName = details.getTestClassName();
            int index = testClassName.lastIndexOf(46);
            testClassName = index == -1 ? "N/A" : testClassName.substring(index + 1);
            b.append(testClassName);
            b.append("  : ");
            b.append(BambooUiUtil.formatTestMethodName(details.getTestMethodName()));
            if (!it.hasNext()) continue;
            b.append("\n");
        }
        return b.toString();
    }

    public static Font getFontForBuildStatus(Object element) {
        BambooBuild build;
        if (element instanceof EclipseBambooBuild && ((build = ((EclipseBambooBuild)element).getBuild()).getPlanState() == PlanState.BUILDING || build.getPlanState() == PlanState.IN_QUEUE)) {
            return CommonFonts.ITALIC;
        }
        return null;
    }
}

