/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.actions;

import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImages;
import com.atlassian.connector.eclipse.internal.bamboo.ui.EclipseBambooBuild;
import com.atlassian.connector.eclipse.internal.bamboo.ui.actions.EclipseBambooBuildSelectionListenerAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.operations.RunBuildJob;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.Nullable;

public class RunBuildAction
extends EclipseBambooBuildSelectionListenerAction {
    private final Action action;

    public RunBuildAction(@Nullable Action action) {
        super(null);
        this.action = action;
        this.initialize();
    }

    private void initialize() {
        this.setText("Run Build");
        this.setToolTipText("Run Build on Server");
        this.setImageDescriptor(BambooImages.RUN_BUILD);
    }

    void onRun(EclipseBambooBuild eclipseBambooBuild) {
        final BambooBuild build = eclipseBambooBuild.getBuild();
        RunBuildJob job = new RunBuildJob(build, eclipseBambooBuild.getTaskRepository());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (RunBuildAction.this.action != null) {
                    RunBuildAction.this.action.run();
                }
                if (event.getResult().getCode() == 4) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError(null, (String)RunBuildAction.this.getText(), (String)("Running build " + build.getPlanKey() + " failed. See Error Log for details."));
                        }
                    });
                }
            }
        });
        job.schedule();
    }

    boolean onUpdateSelection(EclipseBambooBuild eclipseBambooBuild) {
        return eclipseBambooBuild.getBuild().getEnabled();
    }
}

