/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MapIterationInForEachLoopCheck
extends Check {
    private boolean proposeValuesUsage = true;
    private boolean proposeKeySetUsage = false;
    private boolean proposeEntrySetUsage = false;
    public static final String MSG_KEY_KEYSET = "map.iteration.keySet";
    public static final String MSG_KEY_ENTRYSET = "map.iteration.entrySet";
    public static final String MSG_KEY_VALUES = "map.iteration.values";
    private static final String KEY_SET_METHOD_NAME = "keySet";
    private static final String ENTRY_SET_METHOD_NAME = "entrySet";
    private static final String GET_NODE_NAME = "get";
    private static final String GET_VALUE_NODE_NAME = "getValue";
    private static final String GET_KEY_NODE_NAME = "getKey";
    private List<String> mapNamesList = new ArrayList<String>();
    private List<String> qualifiedImportList = new ArrayList<String>();
    private final Set<String> supportedMapImplQualifiedNames = new HashSet<String>();

    public MapIterationInForEachLoopCheck() {
        this.setSupportedMapImplQualifiedNames(new String[]{Map.class.getName(), TreeMap.class.getName(), HashMap.class.getName()});
    }

    public void setSupportedMapImplQualifiedNames(String[] setSupportedMapImplQualifiedNames) {
        this.supportedMapImplQualifiedNames.clear();
        if (setSupportedMapImplQualifiedNames != null) {
            for (String name : setSupportedMapImplQualifiedNames) {
                this.supportedMapImplQualifiedNames.add(name);
                String importPathWithoutClassName = name.substring(0, name.lastIndexOf(".") + 1) + "*";
                this.supportedMapImplQualifiedNames.add(importPathWithoutClassName);
            }
        }
    }

    public void setProposeValuesUsage(boolean proposeValuesUsage) {
        this.proposeValuesUsage = proposeValuesUsage;
    }

    public void setProposeKeySetUsage(boolean proposeKeySetUsage) {
        this.proposeKeySetUsage = proposeKeySetUsage;
    }

    public void setProposeEntrySetUsage(boolean proposeEntrySetUsage) {
        this.proposeEntrySetUsage = proposeEntrySetUsage;
    }

    public int[] getDefaultTokens() {
        return new int[]{91, 30, 10};
    }

    public void beginTree(DetailAST ast) {
        this.qualifiedImportList.clear();
        this.mapNamesList.clear();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 30: {
                String qualifiedMapImportText = this.getMapImportQualifiedName(ast);
                if (qualifiedMapImportText == null) break;
                this.qualifiedImportList.add(qualifiedMapImportText);
                break;
            }
            case 10: {
                DetailAST mapIdentNode;
                String mapName;
                if (this.qualifiedImportList.isEmpty() || !this.isMapVariable(ast) || this.mapNamesList.contains(mapName = (mapIdentNode = ast.findFirstToken(13).getNextSibling()).getText())) break;
                this.mapNamesList.add(mapIdentNode.getText());
                break;
            }
            case 91: {
                String warningMessageKey;
                if (this.qualifiedImportList.isEmpty() || !MapIterationInForEachLoopCheck.isForEach(ast) || (warningMessageKey = this.validate(ast)) == null) break;
                this.log(ast, warningMessageKey, new Object[0]);
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    private String validate(DetailAST forLiteralNode) {
        String warningMessageKey = null;
        DetailAST forEachNode = forLiteralNode.findFirstToken(156);
        DetailAST keySetOrEntrySetNode = this.getKeySetOrEntrySetNode(forEachNode);
        boolean isMapClassField = false;
        if (keySetOrEntrySetNode != null) {
            if (keySetOrEntrySetNode.getPreviousSibling().getChildCount() != 0) {
                isMapClassField = true;
            }
            DetailAST variableDefNode = forEachNode.getFirstChild();
            String keyOrEntryVariableName = variableDefNode.getLastChild().getText();
            String currentMapVariableName = isMapClassField ? keySetOrEntrySetNode.getPreviousSibling().getLastChild().getText() : keySetOrEntrySetNode.getPreviousSibling().getText();
            DetailAST forEachOpeningBrace = forLiteralNode.getLastChild();
            if (!this.isMapPassedIntoAnyMethod(forEachOpeningBrace)) {
                if (this.proposeKeySetUsage && KEY_SET_METHOD_NAME.equals(keySetOrEntrySetNode.getText())) {
                    warningMessageKey = this.checkForWrongKeySetUsage(forEachOpeningBrace, keyOrEntryVariableName, currentMapVariableName, isMapClassField);
                } else if (this.proposeEntrySetUsage) {
                    warningMessageKey = this.checkForWrongEntrySetUsage(forEachOpeningBrace, keyOrEntryVariableName);
                }
            }
        }
        return warningMessageKey;
    }

    private static boolean isForEach(DetailAST forNode) {
        return forNode.findFirstToken(156) != null;
    }

    private DetailAST getKeySetOrEntrySetNode(DetailAST forEachNode) {
        List<DetailAST> identAndThisNodesList = MapIterationInForEachLoopCheck.getSubTreeNodesOfType(forEachNode, 58, 78);
        boolean isMapClassField = false;
        for (DetailAST thisNode : identAndThisNodesList) {
            if (thisNode.getType() != 78) continue;
            isMapClassField = true;
            break;
        }
        DetailAST keySetOrEntrySetNode = null;
        for (DetailAST identNode : identAndThisNodesList) {
            String mapClassName;
            if (!KEY_SET_METHOD_NAME.equals(identNode.getText()) && !ENTRY_SET_METHOD_NAME.equals(identNode.getText()) || !this.mapNamesList.contains(mapClassName = isMapClassField ? identNode.getPreviousSibling().getLastChild().getText() : identNode.getPreviousSibling().getText())) continue;
            keySetOrEntrySetNode = identNode;
            break;
        }
        return keySetOrEntrySetNode;
    }

    private boolean isMapPassedIntoAnyMethod(DetailAST forEachOpeningBraceNode) {
        List<DetailAST> methodCallNodeList = MapIterationInForEachLoopCheck.getSubTreeNodesOfType(forEachOpeningBraceNode, 27);
        for (DetailAST methodCallNode : methodCallNodeList) {
            if (!this.hasMapAsParameter(methodCallNode)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMapAsParameter(DetailAST methodCallNode) {
        boolean result = false;
        List<DetailAST> identNodesList = MapIterationInForEachLoopCheck.getSubTreeNodesOfType(methodCallNode, 58);
        for (String mapName : this.mapNamesList) {
            for (DetailAST identNode : identNodesList) {
                if (!mapName.equals(identNode.getText()) || identNode.getParent().getType() != 28) continue;
                result = true;
            }
        }
        return result;
    }

    private String checkForWrongKeySetUsage(DetailAST forEachOpeningBraceNode, String keyName, String mapName, boolean isMapClassField) {
        String result = null;
        List<DetailAST> identAndLiteralIfNodesList = MapIterationInForEachLoopCheck.getSubTreeNodesOfType(forEachOpeningBraceNode, 58, 83);
        int methodGetCallCount = 0;
        int keyIdentCount = 0;
        for (DetailAST identOrLiteralIfNode : identAndLiteralIfNodesList) {
            DetailAST mapIdentNode = identOrLiteralIfNode.getPreviousSibling();
            if (isMapClassField && mapIdentNode != null) {
                mapIdentNode = mapIdentNode.getLastChild();
            }
            if (mapIdentNode != null && GET_NODE_NAME.equals(identOrLiteralIfNode.getText()) && mapName.equals(mapIdentNode.getText())) {
                ++methodGetCallCount;
            }
            if (!keyName.equals(identOrLiteralIfNode.getText())) continue;
            ++keyIdentCount;
        }
        DetailAST literalIfNode = MapIterationInForEachLoopCheck.getFirstNodeOfType(identAndLiteralIfNodesList, 83);
        int methodGetCallInsideIfCount = 0;
        if (literalIfNode != null) {
            for (DetailAST node : MapIterationInForEachLoopCheck.getSubTreeNodesOfType(literalIfNode, 58)) {
                DetailAST mapIdentNode = node.getPreviousSibling();
                if (isMapClassField && mapIdentNode != null) {
                    mapIdentNode = mapIdentNode.getLastChild();
                }
                if (mapIdentNode == null || !GET_NODE_NAME.equals(node.getText()) || !mapName.equals(mapIdentNode.getText())) continue;
                ++methodGetCallInsideIfCount;
            }
        }
        if (methodGetCallCount != 0 && keyIdentCount != 0) {
            if (this.proposeValuesUsage && methodGetCallCount == keyIdentCount) {
                result = MSG_KEY_VALUES;
            } else if (methodGetCallCount < keyIdentCount && methodGetCallCount > 0 && methodGetCallInsideIfCount != methodGetCallCount) {
                result = MSG_KEY_ENTRYSET;
            }
        }
        return result;
    }

    private String checkForWrongEntrySetUsage(DetailAST forEachOpeningBraceNode, String entryName) {
        String result = null;
        List<DetailAST> identNodesList = MapIterationInForEachLoopCheck.getSubTreeNodesOfType(forEachOpeningBraceNode, 58);
        int methodGetKeyCallCount = 0;
        int methodGetValueCallCount = 0;
        for (DetailAST identNode : identNodesList) {
            DetailAST entryNode = identNode.getPreviousSibling();
            if (entryNode != null && GET_KEY_NODE_NAME.equals(identNode.getText()) && entryName.equals(entryNode.getText())) {
                ++methodGetKeyCallCount;
            }
            if (entryNode == null || !GET_VALUE_NODE_NAME.equals(identNode.getText()) || !entryName.equals(entryNode.getText())) continue;
            ++methodGetValueCallCount;
        }
        if (this.proposeValuesUsage && methodGetKeyCallCount == 0 && methodGetValueCallCount > 0) {
            result = MSG_KEY_VALUES;
        } else if (methodGetKeyCallCount > 0 && methodGetValueCallCount == 0) {
            result = MSG_KEY_KEYSET;
        }
        return result;
    }

    private boolean isMapVariable(DetailAST variableDefNode) {
        boolean result = false;
        List<DetailAST> literaNewNodeslList = MapIterationInForEachLoopCheck.getSubTreeNodesOfType(variableDefNode, 136, 80);
        String className = MapIterationInForEachLoopCheck.getClassName(literaNewNodeslList);
        if (MapIterationInForEachLoopCheck.getFirstNodeOfType(literaNewNodeslList, 80) != null && className != null) {
            result = this.isMapImplementation(className);
        }
        return result;
    }

    private boolean isMapImplementation(String className) {
        return this.isClassContainsInsideQualifiedImportList(className) || this.containsInSupportedMapImplQualifiedNames(className);
    }

    private boolean containsInSupportedMapImplQualifiedNames(String className) {
        boolean result = false;
        for (String supportedMapName : this.supportedMapImplQualifiedNames) {
            int lastDotIndex;
            String packageName;
            if (!supportedMapName.endsWith(className) || !this.qualifiedImportList.contains(packageName = supportedMapName.substring(0, lastDotIndex = supportedMapName.lastIndexOf(".") + 1) + "*")) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isClassContainsInsideQualifiedImportList(String className) {
        boolean result = false;
        for (String mapImplementationQualifiedName : this.qualifiedImportList) {
            if (!mapImplementationQualifiedName.endsWith(className)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static String getClassName(List<DetailAST> literaNewNodesList) {
        for (DetailAST literalNewNode : literaNewNodesList) {
            DetailAST exprNode = literalNewNode.getParent();
            if (exprNode.getParent().getType() != 80) continue;
            return literalNewNode.getFirstChild().getText();
        }
        return null;
    }

    private static DetailAST getFirstNodeOfType(List<DetailAST> nodesList, int aSpecificType) {
        for (DetailAST node : nodesList) {
            if (node.getType() != aSpecificType) continue;
            return node;
        }
        return null;
    }

    private String getMapImportQualifiedName(DetailAST importNode) {
        String mapClassQualifiedName = FullIdent.createFullIdent((DetailAST)importNode.getFirstChild()).getText();
        for (String qualifiedName : this.supportedMapImplQualifiedNames) {
            if (!mapClassQualifiedName.equals(qualifiedName)) continue;
            return mapClassQualifiedName;
        }
        return null;
    }

    private static List<DetailAST> getSubTreeNodesOfType(DetailAST rootNode, int ... tokenTypes) {
        ArrayList<DetailAST> result = new ArrayList<DetailAST>();
        DetailAST finishNode = rootNode.getNextSibling() == null ? rootNode.getLastChild() : rootNode.getNextSibling();
        DetailAST curNode = rootNode;
        while (curNode != null && curNode != finishNode) {
            for (int tokenType : tokenTypes) {
                if (curNode.getType() != tokenType) continue;
                result.add(curNode);
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        return result;
    }
}

