/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.simpleImpl;

import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.text.VisualiserMessages;

public class SimpleMember
implements IMember {
    protected String name;
    protected String tooltip;
    protected Integer size;
    protected String fullname;
    protected IGroup containingGroup;

    public SimpleMember(String s) {
        this.name = s;
        this.setSize(10);
    }

    public String toString() {
        return String.valueOf(VisualiserMessages.SimpleMember) + ":[" + this.fullname + "] " + VisualiserMessages.Size + ":[" + this.size.toString() + "]";
    }

    public void setFullName(String fullName) {
        this.fullname = fullName;
    }

    @Override
    public String getFullname() {
        if (this.fullname == null) {
            this.fullname = this.containingGroup != null && this.containingGroup.getFullname() != null ? String.valueOf(this.containingGroup.getFullname()) + "." + this.name : this.name;
        }
        return this.fullname;
    }

    @Override
    public void setTooltip(String string) {
        this.tooltip = string;
    }

    @Override
    public String getToolTip() {
        if (this.tooltip == null || this.tooltip.length() == 0) {
            return this.getFullname();
        }
        return this.tooltip;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setSize(int s) {
        this.size = new Integer(s);
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public IGroup getContainingGroup() {
        return this.containingGroup;
    }

    @Override
    public void setContainingGroup(IGroup grp) {
        this.containingGroup = grp;
    }
}

