/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model.commands;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.StructuredActivity;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractTextCommand;
import org.w3c.dom.Node;

public class AddCommand
extends AbstractTextCommand {
    private StructuredActivity parent;
    private Activity child;
    private IDOMElement parentElement;
    private IDOMElement childElement;
    private final EditPartViewer viewer;

    public AddCommand(ITextEditor textEditor, EditPartViewer viewer) {
        super(textEditor);
        this.viewer = viewer;
    }

    public boolean canExecute() {
        this.parentElement = this.parent.getInput();
        this.childElement = this.child.getInput();
        if (this.parentElement == null || this.childElement == null) {
            return false;
        }
        Node ancestor = ((NodeImpl)this.parentElement).getCommonAncestor((Node)this.childElement);
        if (ancestor != null && ancestor.equals(this.childElement)) {
            return false;
        }
        List children = this.processor.getChildNames(this.parentElement);
        return children.contains(this.childElement.getNodeName());
    }

    public void execute() {
        this.parent.addChild(this.child);
        Object part = this.viewer.getEditPartRegistry().get(this.child);
        if (part instanceof EditPart) {
            this.viewer.flush();
            this.viewer.reveal((EditPart)part);
            this.viewer.select((EditPart)part);
        }
    }

    public StructuredActivity getParent() {
        return this.parent;
    }

    public void setChild(Activity newChild) {
        this.child = newChild;
    }

    public void setParent(StructuredActivity newParent) {
        this.parent = newParent;
    }
}

