/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.StructuredActivity;
import org.springframework.ide.eclipse.config.graph.model.commands.AddCommand;
import org.springframework.ide.eclipse.config.graph.model.commands.CreateCommand;
import org.springframework.ide.eclipse.config.graph.model.commands.MoveCommand;
import org.springframework.ide.eclipse.config.graph.parts.ActivityPart;

public class GraphXYLayoutPolicy
extends XYLayoutEditPolicy {
    protected Command createAddCommand(EditPart child, Object constraint) {
        Activity activity = (Activity)child.getModel();
        EditPartViewer viewer = this.getHost().getViewer();
        AddCommand add = new AddCommand((ITextEditor)activity.getDiagram().getTextEditor(), viewer);
        add.setParent((StructuredActivity)this.getHost().getModel());
        add.setChild(activity);
        return add;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        if (!(child instanceof ActivityPart)) {
            return null;
        }
        if (!(constraint instanceof Rectangle)) {
            return null;
        }
        ActivityPart part = (ActivityPart)child;
        Activity activity = part.getModelElement();
        IFigure figure = part.getFigure();
        Rectangle oldBounds = figure.getBounds();
        Rectangle newBounds = (Rectangle)constraint;
        if (oldBounds.width != newBounds.width && newBounds.width != -1) {
            return null;
        }
        if (oldBounds.height != newBounds.height && newBounds.height != -1) {
            return null;
        }
        MoveCommand command = new MoveCommand(activity, oldBounds.getCopy(), newBounds.getCopy());
        return command;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NonResizableEditPolicy();
    }

    protected Command getCreateCommand(CreateRequest request) {
        StructuredActivity parent = (StructuredActivity)this.getHost().getModel();
        EditPartViewer viewer = this.getHost().getViewer();
        CreateCommand command = new CreateCommand((ITextEditor)parent.getDiagram().getTextEditor(), viewer);
        command.setParent(parent);
        Activity child = (Activity)request.getNewObject();
        Point location = request.getLocation();
        command.setBounds(this.putActivityAtLocation(child, location));
        command.setChild(child);
        return command;
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure figure = child.getFigure();
        Rectangle rectangle = (Rectangle)figure.getParent().getLayoutManager().getConstraint(figure);
        if (rectangle == null) {
            rectangle = figure.getBounds();
        }
        return rectangle;
    }

    private Rectangle putActivityAtLocation(Activity activity, Point location) {
        Rectangle bounds = activity.getBounds();
        if (bounds == null) {
            bounds = new Rectangle();
        }
        bounds.x = location.x;
        bounds.y = location.y;
        return bounds;
    }
}

