/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.Messages;

public class SpringConfigGraphPage
extends GraphEditor {
    private final AbstractConfigEditor editor;
    private ManagedForm mform;
    private ScrolledForm sform;

    public SpringConfigGraphPage(AbstractConfigEditor editor) {
        this.editor = editor;
    }

    public void createPartControl(Composite parent) {
        if (this.mform == null) {
            this.mform = new ManagedForm(parent);
        }
        this.sform = this.mform.getForm();
        this.sform.getForm().setSeparatorVisible(true);
        this.sform.setText(Messages.getString("SpringConfigGraphPage.FORM_TITLE"));
        this.updateHeader();
        FormToolkit toolkit = this.mform.getToolkit();
        toolkit.decorateFormHeading(this.sform.getForm());
        Composite body = this.sform.getBody();
        body.setLayout((Layout)new FillLayout());
        super.createPartControl(body);
    }

    public void dispose() {
        if (this.mform != null) {
            this.mform.dispose();
        }
        super.dispose();
    }

    public AbstractConfigEditor getConfigEditor() {
        return this.editor;
    }

    protected void updateHeader() {
        if (this.sform != null && !this.sform.isDisposed() && this.editor != null) {
            this.mform.reflow(true);
            if (this.editor.isDirty()) {
                this.sform.setMessage(Messages.getString("SpringConfigGraphPage.DIRTY_INFO"), 1);
            } else {
                this.sform.setMessage(null, 0);
            }
        }
    }
}

