/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.integration.graph.model;

import java.util.Arrays;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.config.core.schemas.IntegrationSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.ParallelActivity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.ui.editors.integration.graph.model.AbstractInboundGatewayModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GatewayModelElement
extends AbstractInboundGatewayModelElement {
    public GatewayModelElement() {
    }

    public GatewayModelElement(IDOMElement input, AbstractConfigGraphDiagram diagram) {
        super(input, diagram);
    }

    @Override
    public String getInputName() {
        return IntegrationSchemaConstants.ELEM_GATEWAY;
    }

    @Override
    public List<String> getPrimaryIncomingAttributes() {
        return Arrays.asList(IntegrationSchemaConstants.ATTR_DEFAULT_REPLY_CHANNEL);
    }

    @Override
    public List<String> getPrimaryOutgoingAttributes() {
        return Arrays.asList(IntegrationSchemaConstants.ATTR_DEFAULT_REQUEST_CHANNEL);
    }

    public List<String> getSecondaryOutgoingAttributes() {
        return Arrays.asList(IntegrationSchemaConstants.ATTR_ERROR_CHANNEL);
    }

    protected List<Transition> getIncomingTransitionsFromXml() {
        List list = super.getIncomingTransitionsFromXml();
        List registry = this.getDiagram().getModelRegistry();
        NodeList methods = this.getInput().getChildNodes();
        int i = 0;
        while (i < methods.getLength()) {
            Node channelRef;
            IDOMElement method;
            String channel;
            Node node = methods.item(i);
            if (node instanceof IDOMElement && node.getLocalName().equals(IntegrationSchemaConstants.ELEM_METHOD) && (channel = (method = (IDOMElement)node).getAttribute(IntegrationSchemaConstants.ATTR_REPLY_CHANNEL)) != null && channel.trim().length() > 0 && (channelRef = this.getDiagram().getReferencedNode(channel)) instanceof IDOMElement) {
                for (Activity activity : registry) {
                    if (activity instanceof ParallelActivity || !activity.getInput().equals(channelRef)) continue;
                    Transition trans = new Transition(activity, (Activity)this, (IDOMNode)method);
                    list.add(trans);
                }
            }
            ++i;
        }
        return list;
    }

    protected List<Transition> getOutgoingTransitionsFromXml() {
        List list = super.getOutgoingTransitionsFromXml();
        List registry = this.getDiagram().getModelRegistry();
        NodeList methods = this.getInput().getChildNodes();
        int i = 0;
        while (i < methods.getLength()) {
            Node channelRef;
            IDOMElement method;
            String channel;
            Node node = methods.item(i);
            if (node instanceof IDOMElement && node.getLocalName().equals(IntegrationSchemaConstants.ELEM_METHOD) && (channel = (method = (IDOMElement)node).getAttribute(IntegrationSchemaConstants.ATTR_REQUEST_CHANNEL)) != null && channel.trim().length() > 0 && (channelRef = this.getDiagram().getReferencedNode(channel)) instanceof IDOMElement) {
                for (Activity activity : registry) {
                    if (activity instanceof ParallelActivity || !activity.getInput().equals(channelRef)) continue;
                    Transition trans = new Transition((Activity)this, activity, (IDOMNode)method);
                    list.add(trans);
                }
            }
            ++i;
        }
        return list;
    }
}

