/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui.launch;

import java.util.Collection;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public abstract class LaunchList {
    private IDebugEventSetListener debugListener;
    private final ListenerList listeners = new ListenerList();

    protected LaunchList() {
        this.debugListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugEvent debugEvent = debugEventArray[n2];
                        LaunchList.this.handleDebugEvent(debugEvent);
                        ++n2;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.debugListener);
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches != null) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                IProcess[] iProcessArray = launch.getProcesses();
                int n3 = iProcessArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcess process = iProcessArray[n4];
                    this.processCreated(process);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    protected final void handleDebugEvent(DebugEvent debugEvent) {
        int kind = debugEvent.getKind();
        switch (kind) {
            case 4: {
                if (!(debugEvent.getSource() instanceof IProcess)) break;
                this.processCreated((IProcess)debugEvent.getSource());
                break;
            }
            case 8: {
                if (!(debugEvent.getSource() instanceof IProcess)) break;
                this.processTerminated((IProcess)debugEvent.getSource());
                break;
            }
        }
    }

    protected abstract void processTerminated(IProcess var1);

    protected abstract void processCreated(IProcess var1);

    public final LaunchList addListener(Listener listener) {
        this.listeners.add((Object)listener);
        return this;
    }

    public final void removeListener(Listener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireChangeEvent() {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((Listener)l).changed();
            ++n2;
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener(this.debugListener);
    }

    public abstract Item getLast();

    public abstract Collection<Item> getLaunches();

    public static class Item {
        public final ILaunchConfiguration conf;
        public final String mode;

        public Item(ILaunchConfiguration conf, String mode) {
            this.conf = conf;
            this.mode = mode;
        }

        public String toString() {
            return "LaunchItem(" + this.conf.getName() + ", " + this.mode + ")";
        }

        public String getName() {
            return this.conf.getName();
        }
    }

    public static interface Listener {
        public void changed();
    }
}

