/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.repository.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.ui.Policy;

public class SVNRemoteResourcePropertySource
implements IPropertySource {
    ISVNRemoteResource resource;
    protected static IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[4];
    protected static IPropertyDescriptor[] lockPropertyDescriptors = new IPropertyDescriptor[5];

    public SVNRemoteResourcePropertySource(ISVNRemoteResource resource) {
        String category = Policy.bind("svn");
        PropertyDescriptor descriptor = new PropertyDescriptor((Object)"svn.name", Policy.bind("SVNRemoteFilePropertySource.name"));
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        SVNRemoteResourcePropertySource.propertyDescriptors[0] = descriptor;
        descriptor = new PropertyDescriptor((Object)"svn.revision", Policy.bind("SVNRemoteFilePropertySource.revision"));
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        SVNRemoteResourcePropertySource.propertyDescriptors[1] = descriptor;
        descriptor = new PropertyDescriptor((Object)"svn.date", Policy.bind("SVNRemoteFilePropertySource.date"));
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        SVNRemoteResourcePropertySource.propertyDescriptors[2] = descriptor;
        descriptor = new PropertyDescriptor((Object)"svn.author", Policy.bind("SVNRemoteFilePropertySource.author"));
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        SVNRemoteResourcePropertySource.propertyDescriptors[3] = descriptor;
        category = Policy.bind("SVNRemoteFilePropertySource.lock");
        descriptor = new PropertyDescriptor((Object)"svn.lock.owner", Policy.bind("SVNRemoteFilePropertySource.lock.owner"));
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        SVNRemoteResourcePropertySource.lockPropertyDescriptors[0] = descriptor;
        descriptor = new PropertyDescriptor((Object)"svn.lock.token", Policy.bind("SVNRemoteFilePropertySource.lock.token"));
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        SVNRemoteResourcePropertySource.lockPropertyDescriptors[1] = descriptor;
        descriptor = new PropertyDescriptor((Object)"svn.lock.comment", Policy.bind("SVNRemoteFilePropertySource.lock.comment"));
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        SVNRemoteResourcePropertySource.lockPropertyDescriptors[2] = descriptor;
        descriptor = new PropertyDescriptor((Object)"svn.lock.creation.date", Policy.bind("SVNRemoteFilePropertySource.lock.creation.date"));
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        SVNRemoteResourcePropertySource.lockPropertyDescriptors[3] = descriptor;
        descriptor = new PropertyDescriptor((Object)"svn.lock.expiration.date", Policy.bind("SVNRemoteFilePropertySource.lock.expiration.date"));
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        SVNRemoteResourcePropertySource.lockPropertyDescriptors[4] = descriptor;
        this.resource = resource;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        RemoteFile remoteFile;
        if (this.resource instanceof RemoteFile && (remoteFile = (RemoteFile)this.resource).getLock() != null) {
            IPropertyDescriptor[] descriptorsWithLocks = new IPropertyDescriptor[]{propertyDescriptors[0], propertyDescriptors[1], propertyDescriptors[2], propertyDescriptors[3], lockPropertyDescriptors[0], lockPropertyDescriptors[1], lockPropertyDescriptors[2], lockPropertyDescriptors[3], lockPropertyDescriptors[4]};
            return descriptorsWithLocks;
        }
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        RemoteFile remoteFile;
        if (id.equals("svn.name")) {
            return this.resource.getName();
        }
        if (id.equals("svn.revision")) {
            return this.resource.getLastChangedRevision().toString();
        }
        if (id.equals("svn.date")) {
            return this.resource.getDate();
        }
        if (id.equals("svn.author")) {
            return this.resource.getAuthor();
        }
        if (this.resource instanceof RemoteFile && (remoteFile = (RemoteFile)this.resource).getLock() != null) {
            if (id.equals("svn.lock.owner") && remoteFile.getLock().getOwner() != null) {
                return remoteFile.getLock().getOwner();
            }
            if (id.equals("svn.lock.token") && remoteFile.getLock().getToken() != null) {
                return remoteFile.getLock().getToken();
            }
            if (id.equals("svn.lock.comment") && remoteFile.getLock().getComment() != null) {
                return remoteFile.getLock().getComment();
            }
            if (id.equals("svn.lock.creation.date") && remoteFile.getLock().getCreationDate() != null) {
                return remoteFile.getLock().getCreationDate();
            }
            if (id.equals("svn.lock.expiration.date") && remoteFile.getLock().getExpirationDate() != null) {
                return remoteFile.getLock().getExpirationDate();
            }
        }
        return "";
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    public void setPropertyValue(Object name, Object value) {
    }
}

